﻿import itertools
titles = ('      kod      ', ' isdigit ', ' isdecimal ', ' isnumeric ', ' znak ')

header_line = '|'+ ('|').join(titles) + '|'
dashed_line = '-' * len(header_line)
col_widths = list(len(item) for item in titles)

print(dashed_line)
print(header_line)
print(dashed_line)

for number in itertools.chain(range(1000), range(4969, 4978), range(8304, 11000)):
    char = chr(number)
    if (char.isdigit() or char.isdecimal() or char.isnumeric()):

        cn = f'{number:>6d} (0x{number:<x})'
        c1 = '+' if char.isdigit() else '-'
        c2 = '+' if char.isdecimal() else '-'
        c3 = '+' if char.isnumeric() else '-'
         
        data_items = (cn, c1, c2, c3, char)
         
        data_line = ''
         
        for data, width in zip(data_items, col_widths):
            data_line += '|' + (f'{data}').center(width)
         
        print(data_line)
