import os
import tempfile
import filecmp
import difflib


def teardown_function(function):
    if os.path.exists('output.txt'):
        os.remove('output.txt')


def test_file_output():
    open('output.txt', 'w').write("Hello World!")  # testowany kod
    assert os.path.exists('output.txt')


def test_file_output_with_tempfile():
    with tempfile.TemporaryFile('w') as f:
        f.write("Hello World!")  # testowany kod


def test_file_output_with_tempdir(tmpdir):
    tempf = tmpdir.join('output.txt')
    tempf.write("Hello World!")  # testowany kod
    content = tempf.read()
    assert content == "Hello World!"
    # assert False  # usuń komentarz, aby zobaczyć ścieżkę do fikstury


def test_compare_files():
    open('output.txt', 'w').write("***Hello World***")  # testowany kod
    lines_result = open('output.txt').readlines()
    lines_expected = open('expected.txt').readlines()
    print('\n'.join(difflib.ndiff(lines_result, lines_expected)))
    assert filecmp.cmp('output.txt', 'expected.txt')
