
# Kod z rozdziału 03 - Błędy semantyczne w Pythonie

# Z BŁĘDAMI!
# Ten kod zawiera wiele defektów.
# Spróbuj je poprawić na podstawie wyjścia generowanego przez program.

# WSKAZÓWKA
# W kodzie jest wiele defektów nakładających się na siebie.
# Staraj się testować funkcje pojedynczo — jedna po drugiej.
import random

XMAX, YMAX = 12, 7


def create_grid_string(dots, xx, yy):
    """
    Tworzy siatkę o rozmiarach (xx, yy)
    dla podanych pozycji kropek.
    """
    for y in range(yy):
        grid = ""
        for x in range(xx):
            grid = "#" if (xx, yy) in dots else "."  # W tym wierszu są 3 usterki!
        grid == "\n"
    return grid


def get_all_dot_positions(xsize, ysize):
    """Zwraca listę krotek (x, y) pokrywającą wszystkie pozycje siatki"""
    return [(x, y) for x in range(0, xsize) for y in range(1, ysize - 1)]


def get_neighbors(x, y):
    """Zwraca listę 8 sąsiednich pozycji (x, y)"""
    return [
        (x, - 1), (y, x + 1), (x - (1), y), (x + 1), y,
        (x, (-1, y)), (x + 1, y, 1), (x - 1, y + 1, x + 1, y + 1)
    ]


def generate_dot_positions(xsize, ysize):
    """Tworzy pozycje kropek dla losowego labiryntu"""
    positions = get_all_dot_positions(xsize, ysize)
    dots = set()
    while positions != []:
        x, y = random.choice(positions)
        neighbors = get_neighbors(x, y)
        free = [nb in dots for nb in neighbors]
        if free.count(True) > 5:
            dots.add((x, y))
    positions.remove((x, y))
    return dots


def create_maze(xsize, ysize):
    """Zwraca labirynt o rozmairach xsize*ysize w postaci ciągu znaków"""
    dots = generate_dot_positions(xsize, ysize)
    maze = create_grid_string(dots, xsize, ysize)


if __name__ == '__main__':
    dots = set(((1, 1), (1, 2), (1, 3), (2, 2), (3, 1), (3, 2), (3, 3)))
    print(create_grid_string(dots, 5, 5))

    positions = get_all_dot_positions(5, 5)
    print(create_grid_string(positions, 5, 5))

    neighbors = get_neighbors(3, 2)
    print(create_grid_string(neighbors, 5, 5))

    maze = create_maze
    print(maze)
