# Functional-Python-Programming-3rd-Edition

To jest repozytorium kodu dla [Programowanie funkcyjne w Pythonie - wydanie trzecie](https://www.packtpub.com/product/functional-python-programming-third-edition/9781803232577), opublikowanego przez [Packt](https://www.packtpub.com/?utm_source=github). Zawiera wszystkie pomocnicze pliki projektowe niezbędne do pracy z książką od początku do końca.

## O książce
Jeśli jesteś programistą Pythona, który chce odkryć, jak wykorzystać możliwości programowania funkcyjnego (FP) i wprowadzić je do własnych programów, ta książka jest dla ciebie niezbędna, nawet jeśli niewiele wiesz o tym paradygmacie.

Poznasz ogólny przegląd pojęć programowania funkcyjnego, typowe cechy funkcyjne, takie jak funkcje pierwszej klasy i funkcje wyższego rzędu, funkcje czyste itp. Zobaczysz, jak można je zaimplementować w Pythonie 3.6. W ten sposób uzyskasz podstawy, na których będziesz budować swoje umiejętności. Następnie odkryjesz typowe optymalizacje funkcyjne dla Pythona, które pomogą Twoim aplikacjom uzyskać jeszcze lepszą wydajność.

Poznasz koncepcje FP, takie jak leniwe wartościowanie przy użyciu funkcji i wyrażeń generatorowych Pythona. Nauczysz się projektować i implementować dekoratory w celu tworzenia funkcji złożonych. Zapoznasz się również z technikami przygotowywania danych i ich eksploracji, a także zapoznasz się ze sposobami wykorzystania biblioteki standardowej Pythona razen z funkcyjnym modelem programowania. Na koniec, aby zakończyć swoją podróż do świata programowania funkcyjnego w Pythonie, przyjrzysz się projektowi PyMonad i kilku większym przykładom. Pozwoli Ci to uzyskać odpowiednią perspektywę.

## Instrukcje i nawigacja
Kod jest zorganizowany w folderach. Każdy folder zaczyna się od numeru, po którym następuje nazwa aplikacji. Na przykład Chapter02.



Kod ma następującą postać:
```
s = 0 
for n in range(1, 10): 
    if n % 3 == 0 or n % 5 == 0: 
        s += n 
print(s) 
```

Autor tej książki zakłada, że Czytelnik ma pewną znajomość Pythona 3 i ogólnych pojęć tworzenia aplikacji. Nie zagłębia się w subtelne lub złożone funkcje Pythona; unika rozważań na temat wewnętrznych aspektów języka.

Zakładam, że Czytelnicy mają pewną znajomość programowania funkcyjnego. Ponieważ Python nie jest funkcyjnym językiem programowania, nie mogłem zagłębiać się w szczegóły pojęć programowania funkcyjnego. Wybrałem te aspekty programowania funkcyjnego, które dobrze pasują do Pythona i wykorzystałem tylko te, które wydają się przydatne.

Niektóre z przykładów wykorzystują eksploracyjną analizę danych (EDA) jako domenę problemu, aby pokazać wartość programowania funkcyjnego. Pomoże w tym znajomość podstaw prawdopodobieństwa i statystyki. Istnieje tylko kilka przykładów, które korzystają z bardziej zaawansowanych pojęć analizy danych.

Aby uruchamiać przykłady, musisz zainstalować Pythona 3.11. 
Więcej informacji na temat Pythona można znaleźć na stronie http://www.python.org/. 

Są dwie ścieżki instalacji wymaganych pakietów:

- Conda. Wymaga dodatkowej instalacji pakietu miniconda. Aby pobrać i zainstalować oprogramowanie Conda oraz użyć go do zbudowania środowiska wirtualnego, odwiedź stronę https://docs.conda.io/en/latest/miniconda.html.

- PIP i venv. Te narzędzia są wbudowane.

### Instalacja za pośrednictem Conda

W przypadku korzystania z narzędzia **conda** należy rozpocząć od instalacji Miniconda.
Zobacz https://docs.conda.io/en/latest/miniconda.html

Po zainstalowaniu narzędzia **conda**,
Wymagane pakiety można zainstalować w następujący sposób:

```bash
conda create -n functional3 --channel=conda-forge python=3.11 --file requirements-conda.txt
conda activate functional3
python -m pip install pymonad==2.4.0
```

Spowoduje to utworzenie i aktywację wirtualnego środowiska dla przykładów w książce.

Pomiń podrozdział dotyczący instalacji PIP.

### Instalacja za pomocą PIP

W przypadku korzystania z narzędzi **PIP** i **venv** wymagane pakiety można zainstalować w następujący sposób:

```bash
python3 -m venv functional3
```

Środowisko wirtualne należy aktywować. Właściwe polecenie różni się w zależności od systemu operacyjnego.

W przypadku systemu Windows należy użyć następującego polecenia:

```bash
functional3\Scripts\activate.bat
```

W przypadku systemów Linux i macOS należy użyć następującego polecenia:

```bash
target functional3/bin/activate
```

Następnie, aby zainstalować wszystkie pakiety, użyj poniższego polecenia:

```bash
python -m pip install -rrequirements.txt
```

### Zestaw testów

Z kodem dostarczono kompleksowy zestaw testów, który można uruchomić za pomocą narzędzia **tox**.
Aby potwierdzić, że wszystkie testy zakończyły się pomyślnie, wykonaj następujące czynności:

```bash
$ tox
```

Aby uruchomić testy dla konkretnego rozdziału, można użyć polecenia podobnego do poniższego:

```bash
$ tox -e ch01
```


## Powiązane produkty
* [Funkcjonalne programowanie w Pythonie](https://www.packtpub.com/application-development/functional-python-programming?utm_source=github&utm_medium=repository&utm_campaign=9781784396992)

* [Learn Python Programming - Fundamentals of Python - Second Edition](https://www.packtpub.com/application-development/learn-python-programming-fundamentals-python?utm_source=github&utm_medium=repository&utm_campaign=9781788996662)

* [Neural Network Programming with Python](https://www.packtpub.com/big-data-and-business-intelligence/neural-network-programming-python?utm_source=github&utm_medium=repository&utm_campaign=9781784398217)

### Sugestie i opinie
[Kliknij tutaj] (https://docs.google.com/forms/d/e/1FAIpQLSe5qwunkGf6PUvzPirPDtuy1Du5Rlzew23UBp2S-P3wB-GcwQ/viewform), jeśli masz jakieś uwagi lub sugestie.


### Pobierz bezpłatny plik PDF

 <i>Jeśli kupiłeś już wersję drukowaną lub Kindle tej książki, możesz otrzymać wersję PDF wolną od DRM bez żadnych kosztów.<br>Po prostu kliknij link, aby odebrać darmowy plik PDF.</i>.
<p align="center"> <a href="https://packt.link/free-ebook/9781803232577">https://packt.link/free-ebook/9781803232577 </a> </p>
