def memoize_uw(func):
    func.cache = {}

    def memoize(*args, **kw):
        if kw:  # Typ frozenset został użyty, aby zapewnić możliwość wygenerowania wartości hash
            key = args, frozenset(kw.items())
        else:
            key = args
        if key not in func.cache:
            func.cache[key] = func(*args, **kw)
        return func.cache[key]
    return functools.update_wrapper(memoize, func)
