class DeepChainMap(ChainMap):
    'Wersja klasy ChainMap pozwalająca na bezpośrednie uaktualnienie wewnętrznego zakresu'

    def __setitem__(self, key, value):
        for mapping in self.maps:
            if key in mapping:
                mapping[key] = value
                return
        self.maps[0][key] = value

    def __delitem__(self, key):
        for mapping in self.maps:
            if key in mapping:
                del mapping[key]
                return
        raise KeyError(key)

>>> d = DeepChainMap({'zebra': 'czarny'}, {'słoń': 'niebieski'}, {'lew': 'żółty'})
>>> d['lew'] = 'pomarańczowy'         # Uaktualnienie istniejącego klucza
>>> d['wąż'] = 'czerwony'           # Nowy klucz został dodany do słownika
>>> del d['słoń']            # Usunięcie istniejącego klucza
DeepChainMap({'zebra': 'czarny', 'wąż': 'czerwony'}, {}, {'lew': 'pomarańczowy'})
