@app.route("/") # Strona główna (domyślna) wyświetlana po przejściu do witryny internetowej
@app.route("/page/<int:page>") # Określona strona witryny internetowej
@login_required # Wymuszone uwierzytelnienie
def entries(page=1):
    """
    Wykonanie zapytania do bazy danych, aby pobrać wpisy bloga

    :param page: Numer strony w witrynie internetowej
    :return: Szablon strony wraz z liczbą podanych wpisów,
    łączami Następny/Poprzedni, numerem strony oraz całkowitą
    liczbą stron w witrynie
    """
    # Indeksy stron rozpoczynają się od zera
    default_entries = 10
    max_entries = 50

    # Określenie liczby wpisów wyświetlanych na stronie
    try:
        entry_limit = int(request.args.get('limit', default_entries)) # Pobranie ograniczenia z argumentu HTML 'limit'
        assert entry_limit > 0 # Liczba musi być dodatnia
        assert entry_limit <= max_entries # Liczba wpisów nie może przekroczyć wartości maksymalnej
    except (ValueError, AssertionError): # Użycie wartości domyślnej, jeśli liczba wpisów nie spełnia wymagań
        entry_limit = default_entries

    page_index = page - 1

    count = session.query(Entry).count()

    start = page_index * PAGINATE_BY # Indeks pierwszego wpisu na stronie
    end = start + PAGINATE_BY # Indeks ostatniego wpisu na stronie
    total_pages = (count - 1) // PAGINATE_BY + 1 # Całkowita liczba stron
    has_next = page_index < total_pages - 1 # Czy istnieje następna strona?
    has_prev = page_index > 0 # Czy istnieje poprzednia strona?

    entries = session.query(Entry)
    entries = entries.order_by(Entry.datetime.desc())
    entries = entries[start:end]

    return render_template("entries.html",
                           entries=entries,
                           has_next=has_next,
                           has_prev=has_prev,
                           page=page,
                           total_pages=total_pages
                           )
