import numpy as np
from matplotlib import pyplot as plt
from multiprocessing import Process, Pipe, Queue

N=50; dx=2./N; dt = .25 * dx**2/2
x=np.linspace(-2,2,N+1)[:-1];
y=np.linspace(-2,2,N+1)[:-1];
x,y=np.meshgrid(x,y)

imax=50000

# Laplasjan
def L(z):
	return (z[:-2,1:-1]+z[2:,1:-1]+z[1:-1,:-2]+z[1:-1,2:]-4*z[1:-1,1:-1])/dx**2

# Prawa strona równania różniczkowego
a = 4e-4; b = 2e-3; tau = .2; k = -.005
def f(u,v):
  return ( dt*( a*L(u) + (u-u**3-v+k)[1:-1,1:-1] ), dt*( b*L(v) + (u-v)[1:-1,1:-1])/tau )

# Inicjalizacja
u=np.random.random(x.shape); v=np.random.random(x.shape)


class PseudoConnection:

  def send(self,x):
    self.x=x

  def recv(self):
    return self.x


def proces(u,v,pl,pp,q,num):
  u = np.hstack(( u[:,:1], u, u[:,-1:] ))
  v = np.hstack(( v[:,:1], v, v[:,-1:] ))
  for _ in range(imax):
    pl.send((u[:,1],v[:,1]))
    pp.send((u[:,-2],v[:,-2]))
    u[:,0], v[:,0] = pl.recv()
    u[:,-1], v[:,-1] = pp.recv()
    du,dv=f(u,v)
    u[1:-1,1:-1]+=du
    v[1:-1,1:-1]+=dv
    u[0,:]=u[1,:]; u[-1,:]=u[-2,:]
    v[0,:]=v[1,:]; v[-1,:]=v[-2,:]
  q.put((num,u[:,1:-1]))

n=4
pi=[PseudoConnection()]+sum([list(Pipe()) for _ in range(n-1)],[])+[PseudoConnection()]
q=Queue()

pr=[Process(target=proces,args=(u[:,1+i*(N-2)//n:1+(i+1)*(N-2)//n],v[:,1+i*(N-2)//n:1+(i+1)*(N-2)//n],pi[2*i],pi[2*i+1],q,i)) for i in range(n)]
for p in pr:
  p.start()
l=sorted([q.get() for _ in range(n)],key=lambda i:i[0])

plt.imshow(np.hstack([i[1] for i in l]),cmap='copper')
plt.show()
  
