import asyncio

async def say_after(what,when):
  await asyncio.sleep(when)
  return what

async def hello(x,name):
  try:
    print (await say_after (f"{name}: Witaj!...", 0.))
    print (await say_after (f"{name}: Po czasie {x}... Żegnaj!", x))
    if name!='koniec':
      asyncio.create_task(hello(2.,'koniec'))
  except asyncio.CancelledError:
    print(f'{name}: Po żadaniu anulowania - sprzątam po sobie i kończę działanie')
    raise asyncio.CancelledError

kp1 = hello(2.,'1')
kp2 = hello(1.,'2')

loop = asyncio.get_event_loop()

task1=loop.create_task(kp1)
task2=loop.create_task(kp2)

wsad=asyncio.gather(task1,task2)
loop.run_until_complete(wsad)
pending = asyncio.all_tasks(loop=loop)
for task in pending:
  task.cancel()
group = (asyncio.gather(*pending,return_exceptions=True))
loop.run_until_complete(group)

loop.close()
