import numpy as np
import matplotlib.pyplot as plt
from multiprocessing import Process, Pipe, Queue

N=200
T=25*np.ones((N,N))
dx=1./N							# [m]
T[0,:]=50				# [C]
T[-1,:]=0				# [C]
k = 5.8e-2 						# [W/K, stal 1mm]
Q=np.zeros((N,N))
for j in range(N//4,3*N//4):
  Q[int(N/2+N/10*np.sin(20.*(j-N/2)/N)),j]=20 / dx		# [W/m**2]

QK = Q*dx**2/k	#[K]

imax=60000

def proces(T,QK,pl,pp,q,num):
  for _ in range(imax):
    pl.send(T[1:-1,:1])     # wysyłamy lewy brzeg na lewo
    pp.send(T[1:-1,-1:])    # wysyłamy prawy brzeg na prawo
    T[1:-1,:]=(T[2:,:]+T[:-2,:]+np.hstack((T[1:-1,1:],pp.recv()))+np.hstack((pl.recv(),T[1:-1,:-1])) + QK[1:-1,:])/4
  q.put((num,T))

n=4
pi=sum([list(Pipe()) for _ in range(n)],[])
pi=[pi[-1]]+pi[:-1]
q=Queue()
pr=[Process(target=proces,args=(T[:,i*N//n:(i+1)*N//n],QK[:,i*N//n:(i+1)*N//n],pi[2*i],pi[2*i+1],q,i)) for i in range(n)]
for p in pr:
  p.start()
l=sorted([q.get() for j in range(n)],key=lambda i:i[0])

plt.imshow(np.hstack([i[1] for i in l]),cmap='jet')
plt.show()
