import asyncio


class Feed:

  def __init__(self,reader):
    self.reader = reader
    
  __aiter__ = lambda self:self
  
  async def __anext__(self):
    data = await self.reader.read(1024)
    if data:
      return data
    else:
      raise StopAsyncIteration


async def polaczenie(reader, writer):
  print('Połączono')
  async for data in Feed(reader):
    print (f'Odebrano: {data.decode().strip()}')
    writer.write(data)
    await writer.drain()
    print (f'Wysłano: {data.decode().strip()}')
  print('Zakończono połączenie')

async def main():
  server = await asyncio.start_server(polaczenie,host='localhost',port=4444)
  async with server:
    await server.serve_forever()
  print('Zamykamy')

asyncio.run(main())

