## Spis treści i notatników


Wystarczy kliknąć odnośnik `ipynb`/`nbviewer` umieszczony przy tytule rozdziału, aby przejrzeć kod źródłowy (obecnie odnośniki do plików zapisanych na dysku są obsługiwane jedynie przez aplikację NbViewer).
**Pamiętaj, że wstawiony tu kod źródłowy został napisany na potrzeby książki i umieściłem go w notatnikach dla Twojej wygody; notatniki mogą okazać się nieprzydatne bez znajomości wzorów oraz tekstu opisowego.**   

- [Instrukcja konfigurowania środowiska Python i aplikacji Jupiter Notebook](./r01/CZYTAJ.md)  

<br>


1. Uczenie maszynowe - Umożliwianie komputerom uczenia się z danych [[dysk](./r01)] [[ipynb](./r01/r01.ipynb)]
2. Trenowanie algorytmów uczenia maszynowego w celach klasyfikacji [[dysk](./r02)] [[ipynb](./r02/r02.ipynb)]
3. Stosowanie klasyfikatorów nauczania maszynowego za pomocą biblioteki scikit-learn [[dysk](./r03)] [[ipynb](./r03/r03.ipynb)]
4. Tworzenie dobrych zbiorów treningowych — wstępne przetwarzanie danych [[dysk](./r04)] [[ipynb](./r04/r04.ipynb)]
5. Kompresja danych poprzez redukcję wymiarowości [[dysk](./r05)] [[ipynb](./r05/r05.ipynb)]
6. Najlepsze metody oceny modelu i strojenie hiperparametryczne [[dysk](./r06)] [[ipynb](./r06/r06.ipynb)]
7. Łączenie różnych modeli w celu uczenia zespołowego [[dysk](./r07)] [[ipynb](./r07/r07.ipynb)]
8. Wykorzystywanie uczenia maszynowego w analizie sentymentów [[dysk](./r08)] [[ipynb](./r08/r08.ipynb)]
9. Wdrażanie modelu uczenia maszynowego do aplikacji sieciowej [[dysk](./r09)] [[ipynb](./r09/r09.ipynb)]
10. Przewidywanie ciągłych zmiennych docelowych za pomocą analizy regresywnej [[dysk](./r10)] [[ipynb](./r10/r10.ipynb)]
11. Praca z nieoznakowanymi danymi — analiza skupień [[dysk](./r11)] [[ipynb](./r11/r11.ipynb)]
12. Trenowanie sztucznych sieci neuronowych w rozpoznawaniu obrazu [[dysk](./r12)] [[ipynb](./r12/r12.ipynb)]
13. Równoległe trenowanie sieci neuronowych za pomocą biblioteki Theano [[dysk](./r13)] [[ipynb](./r13/r13.ipynb)]

<br>

**Dodatkowe notatniki (treść nieuwzględniona w książce)**

- Implementacja regresji logistycznej [[dysk](./bonus)] [[ipynb](./bonus/regresja_logistyczna.ipynb)]
- Konfiguracja podstawowego modelu i przeszukiwania siatki [[dysk](./bonus)] [[ipynb](./bonus/model_i_przeszukiwanie_siatkowe.ipynb)] 
- Rozszerzony przykład zagnieżdżonego sprawdzianu krzyżowego [[dysk](./bonus)] [[ipynb](./bonus/zagnieżdżony_sprawdzian_krzyżowy.ipynb)] 
- Prost(sz)y szablon aplikacji sieciowej Barebones Flask [[przejdź do katalogu](./bonus/aplikacja_flask_przyk01)]
- Wczytywanie pisanych odręcznie znaków z bazy danych MNIST do tablic NumPy [[ipynb](./bonus/wczytywanie_mnist.ipynb)]




## Kontakt

Z chęcią odpowiem na wszelkie pytania! Wystarczy, że napiszesz na adres [email](mailto:mail@sebastianraschka.com)
lub zadasz pytanie na [liście mailingowej Google Groups](https://groups.google.com/forum/#!forum/python-machine-learning-book).

Prowadzę również często aktualizowany strumień na Twitterze - ([@rasbt](https://twitter.com/rasbt)) - poświęcony w całości analizie danych i uczeniu maszynowemu. Mam także własny [blog](http://sebastianraschka.com/articles.html), w którym umieszczam szczególnie interesujące mnie tematy.
