Python. Uczenie maszynowe - kod źródłowy

##  Rozdział 16. Modelowanie danych sekwencyjnych za pomocą rekurencyjnych sieci neuronowych

### Spis treści


- Wprowadzenie do danych sekwencyjnych
  - Modelowanie danych sekwencyjnych — kolejność ma znaczenie
  - Różne kategorie modelowania sekwencji
- Sieci rekurencyjne służące do modelowania sekwencji
  - Struktura sieci RNN i przepływ danych
  - Obliczanie aktywacji w sieciach rekurencyjnych
  - Problemy z uczeniem długofalowych oddziaływań
  - Jednostki LSTM
- Implementowanie wielowarstwowej sieci rekurencyjnej przy użyciu biblioteki TensorFlow do modelowania sekwencji
  - Analiza sentymentów na zestawie danych IMDb za pomocą wielowarstwowej sieci rekurencyjnej
    - Przygotowanie danych
    - Wektor właściwościowy
    - Budowanie modelu sieci rekurencyjnej
      - Etap 1. Definiowanie komórek wielowarstwowej sieci RNN
      - Etap 2. Definiowanie stanów początkowych dla komórek rekurencyjnych
      - Etap 3. Tworzenie sieci rekurencyjnej za pomocą komórek RNN i ich stanów
  - Modelowanie języka na poziomie znaków
    - Przygotowanie danych
    - Tworzenie sieci RNN przetwarzającej znaki
- Podsumowanie

### Informacje na temat korzystania z kodu źródłowego

Zalecanym sposobem przeglądania kodu źródłowego opisywanego w książce jest aplikacja Jupyter Notebook (pliki w formacie `.ipynb`). W ten sposób jesteś w stanie realizować poszczególne fragmenty kodu krok po kroku, a wszystkie wyniki (łącznie z wykresami i rysunkami) są wygofnie generowane w jednym dokumencie.

![](rysunki/jupyter-przykład-1.png)



Konfiguracja aplikacji Jupyter Notebook jest naprawdę prosta: jeżeli korzystasz z platformy Anaconda Python, wystarczy wpisać w terminalu poniższą komendę, aby zainstalować wspomniany program:

    conda install jupyter notebook

Teraz możesz uruchomić aplikację Jupyter Notebook w następujący sposób:

    jupyter notebook

Zostanie otwarte nowe okno w Twojej przeglądarce, w którym możesz przejść do katalogu docelowego zawierającego plik `.ipynb`, który zamierzasz otworzyć.

**Dodatkowe instrukcje dotyczące instalacji i konfiguracji znajdziesz w [pliku CZYTAJ.md w katalogu poświęconym rozdziałowi 1.](../r01/CZYTAJ.md)**.


Oprócz samego kodu źródłowego, dołączyłem również w każdym notatniku Jupyter spis treści, a także nagłówki sekcji, które są spójne z treścią książki. Ponadto umieściłem również występujące w niej rysunki, dzięki czemu powinno Ci się łatwiej przeglądać zawartość plików i pracować z kodem.

![](rysunki/jupyter-przykład-2.png)


Tworząc te notatniki przyświecał mi cel jak największego ułatwienia Tobie ich przeglądania (i tworzenia kodu)! Jeśli jednak nie zamierzasz korzystać z aplikacji Jupyter Notebook, przekonwertowałem te notatniki również do postaci standardowych plików skryptoiwych Pythona (w formacie `.py`), które można przeglądać i edytować w dowolnym edytorze tekstu.