#!/usr/bin/python
import sys
import SimpleXMLRPCServer
from BittyWiki import Wiki

class BittyWikiAPI:
    """Prosta klasa otoczkowa zapewniajca udostpnienie funkcjonalnoci
    BittyWiki jako prosty interfejs API."""

    def __init__(self, wikiBase):
        "Inicjalizacja wiki znajdujcego si w podanym folderze."
        self.wiki = Wiki(wikiBase)

    def getPage(self, pageName):
        "Zwraca tekst wskazanej strony."
        page = self.wiki.getPage(pageName)
        if not page.exists():
            raise NoSuchPage, page.name
        return page.getText()

    def save(self, pageName, newText):
        "Zapisuje stron w wiki."
        page = self.wiki.getPage(pageName)
        page.text = newText
        page.save()
        return "Strona zapisana."

    def delete(self, pageName):
        "Usuwa stron wiki."
        page = self.wiki.getPage(pageName)
        if not page.exists():
            raise NoSuchPage, pageName
        page.delete()
        return "Strona usunita."                    

class NoSuchPage(Exception):
    pass

def handlerSetup(handler, api):
    """Funkcja rejestruje metody interfejsu BittyWiki API
    jako funkcje procedury obsugi XML-RPC."""

    #Zarejestruj standardowe funkcje uywane przez XML-RPC, aby poinformowa,
    #ktre funkcje bd dostpne na serwerze.
    handler.register_introspection_functions()

    #Zarejestruj metody BittyWiki API jako funkcje XML-RPC w przestrzeni
    #nazw 'bittywiki'.
    handler.register_function(api.getPage, 'bittywiki.getPage')
    handler.register_function(api.save, 'bittywiki.save')
    handler.register_function(api.delete, 'bittywiki.delete')

    #Oto przykad rejestracji wszystkich trzech metod w jednym wierszu
    #kodu dziki zastosowaniu caego obiektu. Rozwizanie jest zakomentowane,
    #poniewa w starszych wersjach Pythona zawierao luk w zabezpieczeniach
    #(dotyczy wersji 2.2, 2.3.4 i 2.4.0). Szczegw szukaj na stronie
    #http://www.python.org/security/PSF-2005-001/.
    #
    #handler.register_instance(api)
    #
    #Naley pamita, e w tym rozwizaniu zrejestracj, funkcje XML-RPC
    #nie bd miay przedrostka 'bittywiki.': pojawi si nazwy typy
    #"getPage" zamiast "bittywiki.getPage". Aby tego unikn, mona 
    #posuy si nastpujc sztuczk:
    #class Container:
    #    pass
    #container = Container()
    #container.bittywiki = api
    #handler.register_instance(container)


if __name__ == '__main__':
    WIKI_BASE = 'wiki/'
    api = BittyWikiAPI(WIKI_BASE)
    standalonePort = None
    if len(sys.argv) > 1:
        #Uytkownik przekaza numer portu; oznacza to ch utworzenia
        #niezalenego serwera.
        standalonePort = sys.argv[1]
        try:
            standalonePort = int(standalonePort)
        except ValueError:
            #To jednak nie by numer portu. Poinformuj uytkownika o poprawnej skadni.
            scriptName = sys.argv[0]
            print 'Uycie:'
            print ' "%s [numer portu]" uruchamia niezaleny serwer.' \
                  % scriptName
            print ' "%s" w celu wywoania jako CGI.' % scriptName
            sys.exit(1)
        isStandalone = 1
        print "Uruchamiam niezaleny serwer XML-RPC na porcie %s." \
              % standalonePort
        handler = SimpleXMLRPCServer.SimpleXMLRPCServer\
                  (('localhost', standalonePort))
    else:
        #Nie podano numeru portu, wic wywoanie CGI.
        handler = SimpleXMLRPCServer.CGIXMLRPCRequestHandler()

    #Krok rejestracji funkcji jest taki sam dla
    #SimpleXMLRPCServer i CGIXMLRPCRequestHandler.
    handlerSetup(handler, api)

    if standalonePort:
        handler.serve_forever()
    else:
        handler.handle_request()
