#!/usr/bin/python
from BaseHTTPServer import HTTPServer
from SimpleHTTPServer import SimpleHTTPRequestHandler

#Port lokalnego komputera, do ktrego ma zosta dczony serwer.
#Serwer dostpny jest przy uyciu adresu URL "http://localhost:8000/".
PORT = 8000

class VisibleHTTPRequestHandler(SimpleHTTPRequestHandler):
    """Klasa ta zachowuje si podobnie do SimpleHTTPRequestHandler, ale zamiast
    wywietla na standardowym wyjciu jedynie podsumowanie dania, wywietla
    pen tre dania i odpowiedzi HTTP."""

    def log_request(self, code='-', size='-'):
        """Wywietla szczegy dania. Metoda jest wywoywana przez
        SimpleHTTPRequestHandler.do_GET()."""
        print self._heading("danie HTTP")
        #Najpierw wywietl ientyfikator zasobu i operacj.
        print self.raw_requestline,
        #Nastpnie wywietl pozostae dane.
        for header, value in self.headers.items():            
            print header + ":", value

    def do_GET(self, method='GET'):
        """Obsuguje danie GET w ten sam sposb, co
        SimpleHTTPRequestHandler, ale wywietla rwnie tre odpowiedzi
        na standardowym wyjciu."""

        #Zastpuje obiekt sucy do wysyania odpowiedzi jego zmodyfikowan
        #wersj, ktra kopiuje wszystkie wysyane dane w miejsc, ktre 
        #moemy sprawdzi. Nastpnie przekazuje rzeczywist obsug odpowiedzi
        #SimpleHTTPRequestHandler.
        self.wfile = FileWrapper(self.wfile)
        SimpleHTTPRequestHandler.do_GET(self)

        #Obiekt tymczasowy zawiera wszystkie wysane dane odpowiedzi.
        #Jest gotowy do ich wywietlenia. danie rwnie zostao wywietlone
        #dziki modyfikacji metody log_request()
        #(wywoanej przez metod do_GET z SimpleHTTPRequestHandler).
        print ""
        print self._heading("Odpowied HTTP")
        print self.wfile

    def _heading(self, s):
        """Ta metoda pomocnicza formatuje odpowiednio tekst nad nagwkami
        dania i odpowiedzi."""    
        line = '=' * len(s)
        return line + '\n' + s + '\n' + line

class FileWrapper:
    """Klasa otacza podstawow klas pliku, by wszystko zapisywane do pliku byo
    rwnie po cichu zapamitywane w buforze w celu pniejszego wykorzystania.
    """

    def __init__(self, wfile):
        """wfile to obiekt pliku, do ktrego zapisywana jest odpowied.
        Zastpujemy go, by zapewni zapamietywanie dodatkowych informacji."""
        self.wfile = wfile
        self.contents = []

    def __getattr__(self, key):
        """Jeli komu nie udao si uzyska atrybutu tego obiektu, zapewne
        mia zamiar pobra go dla oryginalnego obiektu pliku.
        Delegujemy wic wywoanie do oryginalnej wersji."""
        return getattr(self.wfile, key)

    def write(self, s):
        """Zapisuje dane do 'rzeczywistego' pliku a take do specjalnego bufora
        w celu ich wywietlenia w dalszej czci programu."""
        self.contents.append(s)
        self.wfile.write(s)

    def __str__(self):
        """Zwraca zebrane do tej pory dane jako tekst."""
        return ''.join(self.contents)

if __name__ == '__main__':
    httpd = HTTPServer(('localhost', PORT), VisibleHTTPRequestHandler)
    httpd.serve_forever()
