import SOAPpy

class GoogleAPI:

    "Implementuje cz Google Web API jako prost klas Pythona."

    URL = 'http://api.google.com/search/beta2'
    NAMESPACE = 'urn:GoogleSearch'

    def __init__(self):
        self.server = SOAPpy.SOAPProxy(self.URL, self.NAMESPACE)
        #Te dwa polecenia z SOAPpy powoduj wywietlanie penego
        #dania i odpowiedzi dla kadego wywoania SOAP, co pozwala
        #pozna szczegy dziaania protokou.
        #self.server.config.dumpSOAPOut=1
        #self.server.config.dumpSOAPIn=1
    
    def doGoogleSearch(self, key, searchString, resultOffset=0, maxResults=10,
                       filter=True, restrict="", safeSearch=True,
                       languageRestrict="pl"):
        """Metoda pomocnicza, ktra pozwala ukry fakt, i wywoanie
        doGoogleSearch wymaga 10 argumantw, z ktrych 2 s przestarzae
        i nie powinny by stosowane. Wywoujc t metod, mona wykona 
        wyszukiwanie, podajc jedynie klczu Google API i poszukiwany tekst
        Znaczenie pozostaych argumentw jest szczegowo opisane w 
        dokumentacji Google Web API."""
        return self.server.doGoogleSearch(key, searchString, resultOffset,
                                          maxResults, filter, restrict,
                                          safeSearch, languageRestrict, "", "")

if __name__ == '__main__':
    import sys
    if len(sys.argv) != 3:
        print "Uycie: %s [klucz Google] [szukana fraza]" % sys.argv[0]
        sys.exit(1)
    key, term = sys.argv[1:3]
    resultObj = GoogleAPI().doGoogleSearch(key, term)
    results = resultObj.resultElements
    print 'Pierwszych %s wynikw dla "%s":' % (len(results), term)
    for result in results:
        print " %s: %s" % (result.title, result.URL)
