#!/usr/bin/python
from poplib import POP3
import email
class SubjectLister(POP3):

    """Pocz si ze skrzynk protokoem POP3 i wywietl temat 
    kadej wiadomoci."""

    def __init__(self, server, username, password):
        "Pocz si z serwerem POP3."
        POP3.__init__(self, server, 110)
        #Usu komentarz z poniszego wiersza, by zobaczy peen proces komunikacji.
        #self.set_debuglevel(2)
        self.user(username)
        response = self.pass_(password)
        if response[:3] == '+OK':
            #Wystpi problem z poczeniem.
            raise Exception, response	

    def summarize(self):
        "Pobierz kad wiadomo, przetwrz j i wywietl temat."
        numMessages = self.stat()[0]
        print '%d wiadomoci w skrzynce.' % numMessages
        parser = email.Parser.Parser()
        for messageNum in range(1, numMessages+1):
	          messageString = '\n'.join(self.top(messageNum, 0)[1])
            message = parser.parsestr(messageString)
            #Przekazanie True do parser.parsestr() powoduje przetwarzanie
            #tylko i wycznie nagwkw. Poniewa interesuje nas pobranie
            #caoci, standardowa wersja moe chwil potrwa. Wersja pobierajca
            #tylko nagwki jest dostpna od Python 2.2.2 i nowszego.
            #message = parser.parsestr(messageString, True)
            print '', message['Subject']

class TopBasedSubjectLister(SubjectLister):

    def summarize(self):
        """Pobierz pierwsz cz wiadomoci i odnajd nagwek 'Subject:'."""
        print '%d wiadomoci w skrzynce.' % self.numMessages
        for messageNum in range(1, self.numMessages+1):
            #Pobiera tylko i wycznie nagwki. W nagwach 
            #poszukuje tematu.
            for header in self.top(messageNum, 0)[1]:
                if header.find('Subject:') == 0:
                    print header[len('Subject:'):]
                    break

if __name__ == '__main__':
    import sys
    if len(sys.argv) < 4:
        print 'Uycie: %s [adres serwera POP3] [uytkownik POP3] [haso POP3]' % sys.argv[0]
        sys.exit(0)
    lister = TopBasedSubjectLister(sys.argv[1], sys.argv[2], sys.argv[3])
    lister.summarize()
