#!/usr/bin/env python

from Ft.Xml import InputSource
from Ft.Xml.Xslt.Processor import Processor
from xml.parsers.xmlproc import xmlval

class docErrorHandler(xmlval.ErrorHandler):
  def warning(self, message):
    print "Ostrzeenie: " + message
  def error(self, message):
    print "Bd: " + message
  def fatal(self, message):
    print "Bd krytyczny: " + message

# Otwrz pliki HTML i XSTL jako strumienie.
html = open('mojblog.html')
xsl = open('HTMLnaRSS.xsl')

# Przetwrz strumienie i utwrz z nich rda wejciowe.
parsedxml = InputSource.DefaultFactory.fromStream(html, "mojblog.html")
parsedxsl = InputSource.DefaultFactory.fromStream(xsl, "HTMLnaRSS.xsl")

# Utwrz nowy procesor, docz do niego arkusz stylu a nastpnie przekszta XML.
processor = Processor()
processor.appendStylesheet(parsedxsl)
HTML = processor.run(parsedxml)

# Zapisz wyjciowy dokument RSS w pliku.
output = open("kanalRSS.xml", 'w')
output.write(HTML)
output.close

# Dokonaj walidacji kanau RSS.
parser=xmlval.XMLValidator()
parser.set_error_handler(docErrorHandler(parser))
parser.parse_resource("kanalRSS.xml")
