import os, os.path
import re
from stat import *

# To pierwsza wersja. Uyj jej przy pierwszym wywoaniu
# testu test_find.py
def find (where='.*', content=None, start='.', ext=None, logic=None):
    return ([])

# To druga wersja. Dodaje niektre funkcje, ale nie
# oblewa niektre teksty.
def find (where='.*', content=None, start='.', ext=None, logic=None):
   context = {}
   context['gdzie'] = where
   context['zawarto'] = content
   context['zwr'] = []

   os.path.walk (start, find_file, context)

   return context['zwr']

def find_file (context, dir, files):
   for file in files:
      # Wydobd informacje na temat pliku.
      path = os.path.join (dir, file)
      path = os.path.normcase (path)
      try:
         ext = os.path.splitext (file)[1][1:]
      except:
         ext = ''
      stat = os.stat(path)
      size = stat[ST_SIZE]

      # Nie traktuj filderw jak pliki.
      if S_ISDIR(stat[ST_MODE]): continue

      # Dokonaj filtracji na podstawie oryginalnych parametrw find()
      if not re.search (context['gdzie'], file): continue

      # Filtracj zawartoci wykonuj jako ostatni, by zminimalizowa
      # koszt wyszukiwania.
      if context['zawarto']:
         f = open (path, 'r')
         match = 0
         for l in f.readlines():
            if re.search(context['zawarto'], l):
               match = 1
               break
         f.close()
         if not match: continue

      # Utwrz zwracan warto dla wszystkich plikw speniajcych podane kryteria.
      file_return = (path, file, ext, size)
      context['zwr'].append (file_return)


# To trzecia, najbardziej rozbudowana wersja. Udaje jej si
# sprosta wszystkim testom z test_find.py.

def find (where='.*', content=None, start='.', ext=None, logic=None):
   context = {}
   context['gdzie'] = where
   context['zawarto'] = content
   context['zwr'] = []
   context['rozszerzenie'] = ext
   context['logika'] = logic

   os.path.walk (start, find_file, context)

   return context['zwr']

def find_file (context, dir, files):
   for file in files:
      # Pobierz informacje na temat pliku.
      path = os.path.join (dir, file)
      path = os.path.normcase (path)
      try:
         ext = os.path.splitext (file)[1][1:]
      except:
         ext = ''
      stat = os.stat(path)
      size = stat[ST_SIZE]

      # Nie traktuj folderw jak pliki.
      if S_ISDIR(stat[ST_MODE]): continue

      # Dokonaj filtracji na podstawie parametrw z find().
      if not re.search (context['gdzie'], file): continue
      if context['rozszerzenie']:
         if ext != context['rozszerzenie']: continue
      if context['logika']:
         arg = {}
         arg['cieka'] = path
         arg['rozszerzenie'] = ext
         arg['stat'] = stat
         arg['rozmiar'] = size
         arg['modyfikacja'] = stat[ST_MTIME]

         if not context['logika'](arg): continue

      # Filtracj zawartoci wykonuj na kocu, bo jest najbardziej kosztowna.
      if context['zawarto']:
         f = open (path, 'r')
         match = 0
         for l in f.readlines():
            if re.search(context['zawarto'], l):
               match = 1
               break
         f.close()
         if not match: continue

      # Utwrz zwracan warto dla wszystkich plikw speniajcych podane kryteria.
      file_return = (path, file, ext, size)
      context['zwr'].append (file_return)
