#!/usr/bin/python
import re
import xmlrpclib

class WikiReplaceSpider:
    "Klasa wykonujca operacj znajd i wyszukaj dla stron wiki."

    WIKI_WORD = re.compile('(([A-Z][a-z0-9]*){2,})')

    def __init__(self, rpcURL):
        "Adres URL dla interfejsu BittyWiki XML-RPC API."
        server = xmlrpclib.ServerProxy(rpcURL)
        self.api = server.bittywiki

    def replace(self, find, replace):
        """Zaczyna przechodzenie przez strony wiki od strony gwnej, pobierajc
        je i modyfikujc za pomoc odpowiedniego API."""

        processed = {} #Zapamituj ju przeanalizowane strony.
        todo = ['StronaGlowna'] #Zacznij od strony gwnej.
        while todo:
            for pageName in todo:
                print 'Sprawdzam "%s"' % pageName
                try:
                    pageText = self.api.getPage(pageName)
                except xmlrpclib.Fault, fault:
                    if fault.faultString.find("NoSuchPage") != -1:
                        #Znaleziono SowoWiki, ktre nie ma jeszcze swojej strony.
                        #Nie stanowi ono adnego problemu.
                        pass
                    else:
                        #Inny problem, zgo wyjtek.
                        raise xmlrpclib.Fault, fault
                else:
                    #Strona istnieje, wiec j przetwrz.
                    #Najpierw znajd SowaWiki na stronie. Mog one zawiera
                    #referencje do innych stron.
                    for wikiWord in self.WIKI_WORD.findall(pageText):
                        linkPage = wikiWord[0]
                        if not processed.get(linkPage) and linkPage not in todo:
                            #Ta strona nie zozstaa jeszcze przetworzona.
                            #Umie j na odpowiedniej licie.
                            todo.append(linkPage)

                    #Uruchom wyszukiwanie i zastpowanie dla strony, by uzyska
                    #jej now tre.
                    newText = pageText.replace(find, replace)

                    #Sprawd, czy nazwa strony odpowiada wzorcowi zastpowania.
                    #Jeli tak, usu j i utwrz now z nowym tekstem.
                    #W przeciwnym razie jedynie zmodyfikuj tekst.
                    newPageName = pageName.replace(find, replace)
                    if newPageName != pageName:
                        print ' Usuwam "%s", utworz "%s"' \
                              % (pageName, newPageName)
                        self.api.delete(pageName)
                    if newPageName != pageName or newText != pageText:
                        print ' Zapisuj "%s"' % newPageName
                        self.api.save(newPageName, newText)
                    #Oznacz now stron jako przetworzon, by nie analizowa
                    #jej po raz drugi.
                    if newPageName != pageName:
                        processed[newPageName] = True
                processed[pageName] = True
                todo.remove(pageName)

if __name__ == '__main__':
    import sys
    if len(sys.argv) == 4:
        rpcURL, find, replace = sys.argv[1:]
    else:
        print 'Uycie: %s [adres URL BittyWiki XML-RPC API] [znajd] [zastp]' \
              % sys.argv[0]
        sys.exit(1)
    WikiReplaceSpider(rpcURL).replace(find, replace)
