import xmlrpclib

class MeerkatSummary:
    """Wymienia kanay pasujce do zadenego kryterium w kolejnoci malejcej
    na podstawie liczby pasujcych historii."""

    SERVER_URL = 'http://www.oreillynet.com/meerkat/xml-rpc/server.php'

    def __init__(self):
        "Utworzenie referencji do serwera Meerkat."

        #Przekazanie 'verbose=True' do konstruktora serwera spowoduje
        #wywietlanie tekstu odpowiedzi i dania dla kaego wywoania XML-RPC,
        #co pozwala atwo pozna szczegy dziaania protokou.
        #verbose = True

        verbose = False
        server = xmlrpclib.ServerProxy(self.SERVER_URL, verbose=verbose)
        self.meerkat = server.meerkat

    def findChannels(self, searchTerm):
        "Sprawd, ktre kanay maj najwicej wpisw na zadany temat."
        channelTotals = {}
        items = self.meerkat.getItems({'search' : searchTerm,
                                       'channels' : True})
        for item in items:
            channel = item['channel']
            totalForChannel = channelTotals.get(channel, 0)
            totalForChannel += 1
            channelTotals[channel] = totalForChannel
        totalAndChannel = [(a,b) for b,a in channelTotals.items()]
        totalAndChannel.sort()
        totalAndChannel.reverse()
        print 'Raport Meerkat dla "%s":' % searchTerm
        for total, channel in totalAndChannel:
            print "%2d %s" % (total, channel)

if __name__ == '__main__':
    import sys
    if len(sys.argv) != 2:
        print "Uycie: %s [szukany termin]" % sys.argv[0]
        sys.exit(1)
    else:
        MeerkatSummary().findChannels(sys.argv[1])
