#!/usr/bin/python

from Ft.Xml import InputSource
from Ft.Xml.Xslt.Processor import Processor

# Otwrz pliki XML i XSTL jako strumienie.
xml = open('biblioteczka.xml')
xsl = open('biblioteczkaHTML.xsl')

# Przetwrz strumienie i utwrz z nich rda wejciowe.
parsedxml = InputSource.DefaultFactory.fromStream(xml , "biblioteczka.xml")
parsedxsl = InputSource.DefaultFactory.fromStream(xsl, "biblioteczkaHTML.xsl")

# Utwrz nowy procesor, docz do niego arkusz stylu a nastpnie przekszta XML.
processor = Processor()
processor.appendStylesheet(parsedxsl)
HTML = processor.run(parsedxml)

# Zapisz wyjciowy dokument XML w pliku.
output = open("biblioteczka.html", 'w')
output.write(HTML)
output.close
