#!/usr/bin/python


# Funkcja in_fridge przechodzi w rozdziale kilka modyfikacji.
# Gdy plik zostanie wczytany do interpretera Pythona
# uywana bdzie jedynie ostatnia jej wersja.

# Pierwsza
def in_fridge():
    try:
        count = fridge[wanted_food]
    except KeyError:
        count = 0
    return count

# Druga, przedstawia sposb tworzenia dokumentacji
def in_fridge ():
    """Funkcja sprawdza, czy w lodwce znajduje si dany produkt.
Sownik fridge musi zosta zdefiniowany poza funkcj.
Nazw poszukiwanego produktu naley umieci w zmiennej wanted_food."""
    try: 
        count = fridge[wanted_food] 
    except KeyError:
        count = 0
    return count

# Trzecia
def in_fridge(some_fridge, desired_item):
    """Funkcja sprawdza, czy w lodwce znajduje si dany produkt.
Pierwszy parametr jest sownikiem.
Drugi parametr okrela poszukiwany w lodwce produkt."""
    try:
        count = some_fridge[desired_item]
    except KeyError:
        count = 0
    return count


# To jest pierwsza wersja funkcji make_omelette. Podobnie, jak w przypadku
# pozostaych funkcji, uywana jest jedynie ostatnia jej wersja, jeli
# cay skrypt uruchomi si w interpreterze Pythona. Sprawd dziaanie
# poszczeglnych wersji funkcji, czytajc rozdzia ksiki. 
# W tym celu skopiuj i wklej kod danej funkcji do interpretera lub
# osobnego pliku.

def make_omelet(omelet_type):
    """Przygotowuje omlet.  Mona przekaza albo sownik
    zawierajcy skadniki wymagane do wykonania omletu lub te
    wskaza rodzaj ompletu do wykonania, ktry funkcja ju zna."""
    if type(omelet_type) == type({}):
        print "omelet_type to sownik ze skadnikami"
        return make_food(omelet_type, "specalny")
    elif type(omelet_type) == type(""):
        omelet_ingredients = get_omelet_ingredients(omelet_type)
        return make_food(omelet_ingredients, omelet_type)
    else:
        print "Nie wiem, czy potrafi tworzy taki omlet: %s" % omelet_type

# Oto funkcje pomocnicze dla funkcji make_omelet.

def get_omelet_ingredients(omelet_name):
    """Tworzy sowniki zawierajce nazwy skadnikw rnych typw omletw,
a take ich iloci"""
    # Wszystkie omlety wymagaj jajka i mleka
    ingredients = {"jajko":2, "mleko":1}
    if omelet_name == "serowy":
        ingredients["cheddar"] = 2
    elif omelet_name == "zachodni":
        ingredients["ser_jack"] = 2
        ingredients["szynka"]         = 1
        ingredients["pieprz"]      = 1
        ingredients["cebula"]       = 1
    elif omelet_Name == "grecki":
        ingredients["ser_feta"] = 2
        ingredients["szpinak"]     = 2
    else:
        print "Niestety tego nie ma w menu!"
        return None
    return ingredients

def make_food(ingredients_needed, food_name):
    """make_food(ingredients_needed, food_name)
    Pobiera skadniki z ingredients_needed, wypisuje je i zwraca nazw potrawy"""
    for ingredient in ingredients_needed.keys():
        print "Dodaj %d %s, aby wykona omlet %s" % (ingredients_needed[ingredient], ingredient, food_name)
    print "Wykonano omlet %s" % food_name
    return food_name

# Ta implementacja funkcji make_omelet przedstawia tworzenie jednych
# funkcji wewntrz innych, by w ten sposb make_omelet uczy bardziej
# zwart i niezalen.

def make_omelet(omelet_type):
    """Przygotowuje omlet.  Mona przekaza albo sownik
    zawierajcy skadniki wymagane do wykonania omletu lub te
    wskaza rodzaj ompletu do wykonania, ktry funkcja ju zna."""
    def get_omelet_ingredients(omelet_name):
        """Tworzy sowniki zawierajce nazwy skadnikw rnych typw omletw,
        a take ich iloci"""
        ingredients = {"jajko":2, "mleko":1}
        if omelet_name == "serowy":
            ingredients["cheddar"] = 2
        elif omelet_name == "zachodni":
            ingredients["ser_jack"] = 2
	# Tutaj naley umieci pozosta cz funkcji
	# get_omelet_ingredients. Nie umiecilimy jej tu, by zwikszy 
	# czytelno kodu
    if type(omelet_type) == type({}):
        print "omelet_type to sownik ze skadnikami"
        return make_food(omelet_type, "specjalny")
    elif type(omelet_type) == type(""):
        omelet_ingredients = get_omelet_ingredients(omelet_type)
        return make_food(omelet_ingredients, omelet_type)
    else:
        print "Nie wiem, czy potrafi tworzy taki omlet: %s" % omelet_type
    
# Tak implementacja make_omelet zgasza wyjtek.
def make_omelet(omelet_type):
    """Przygotowuje omlet.  Mona przekaza albo sownik
    zawierajcy skadniki wymagane do wykonania omletu lub te
    wskaza rodzaj ompletu do wykonania, ktry funkcja ju zna."""
    def get_omelet_ingredients(omelet_name):
        """Tworzy sowniki zawierajce nazwy skadnikw rnych typw omletw,
        a take ich iloci"""
        ingredients = {"jajko":2, "mleko":1}
        if omelet_name == "serowy":
            ingredients["cheddar"] = 2
        elif omelet_name == "zachodni":
            ingredients["ser_jack"] = 2
	# Tutaj naley umieci pozosta cz funkcji
	# get_omelet_ingredients. Nie umiecilimy jej tu, by zwikszy 
	# czytelno kodu
    if type(omelet_type) == type({}):
        print "omelet_type to sownik ze skadnikami"
        return make_food(omelet_type, "specjalny")
    elif type(omelet_type) == type(""):
        omelet_ingredients = get_omelet_ingredients(omelet_type)
        return make_food(omelet_ingredients, omelet_type)
    else:
        raise TypeError, "Nieznany rodzaj omletu: %s" % omelet_type

