"""Ten modu zawiera kod rdzenia BittyWiki. Kod ten nie jest zwizany z 
adnym konkretnym interfejsem."""

import re
import os

class Wiki:
    "Klasa reprezentujca wiki jako cao."
    HOME_PAGE_NAME = "StronaGlowna"

    def __init__(self, base):
        "Inicjalizacja wiki stosujcej przekazany folder gwny."
        self.base = base

        if not os.path.exists(self.base):
            os.makedirs(self.base)
        elif not os.path.isdir(self.base):
            raise IOError('Podana baza wiki "%s" nie jest folderem!' % self.base)

    def getPage(self, name=None):
        """Pobiera wskazan stron wiki, ktra moe istnie, ale nie musi."""
        if not name:
            name = self.HOME_PAGE_NAME
        return Page(self, name)

class Page:
    """Klasa reprezentujca jedn stron wiki. Zawiera ca logik zwizan
    z modyfikacj strony i sprawdzaniem, na ktre inne strony wskazuje."""

    #Jako SowoWiki traktujemy kade sowo zaczynajce si z wielkiej litery,
    #zawierajce inn wielk liter i skadajcesi z liter lub cyfr.
    WIKI_WORD_MATCH = "(([A-Z][a-z0-9]*){2,})"
    WIKI_WORD = re.compile(WIKI_WORD_MATCH)
    WIKI_WORD_ALONE = re.compile('^%s$' % WIKI_WORD_MATCH)

    def __init__(self, wiki, name):
        """Inicjalizuje stron dla wskazsnego wiki o przekazanej nazwie.
        Sprawdza, czy nazwa jest poprawna. Strona moe istnie, ale 
        niekoniecznie musi tak by."""

        #WIKI_WORD dopasowuje si do SowaWiki w dowolnym miejscu. Chcemy mie
        #pewno, e strona to StrinaWiki i nic innego.
        if not self.WIKI_WORD_ALONE.match(name):
            raise NotWikiWord, name
        self.wiki = wiki
        self.name = name
        self.path = os.path.join(self.wiki.base, name)

    def exists(self):
        "Zwraca warto true, jeli istnieje strona wiki o takiej nazwie."
        return os.path.isfile(self.path)

    def load(self):
        "Wczytuje stron z dysku, jeli istnieje."
        if not hasattr(self, 'text'):
            self.text = ''
            if self.exists():
                self.text = open(self.path, 'r').read()
            
    def save(self):
        "Zapisuje stron. Jeli nie istniaa, tworzy j."
        if not hasattr(self, 'text'):
            self.text = ''
        out = open(self.path, 'w')
        out.write(self.text)
        out.close()

    def delete(self):
        "Usuwa stron, zakadajc, e wczeniej istniaa."
        if self.exists():
            os.remove(self.path)

    def getText(self):
        "Zwraca surowy tekst strony."
        self.load()
        return self.text

class NotWikiWord(Exception):
    """Wyjtek zgaszany wtedy, gdy kto chce przekaza sowo nie bdce
    SlowemWiki jako SowoWiki.."""
    pass
