#!/usr/bin/env python

from math import sin, cos, pi

def trajectory(velocity, angle):
    """Oblicz czas lotu i zasig pocisku.
    
    Dla kuli wystrzelonej z prdkoci wylotow 'velocity' podan w
    metrach na sekund pod ktem 'angle' w stponiach wzgldem poziomu
    zwraca czas lotu i zasig w metrach, pomijajc tarcie."""

    # Przyspieszenie grawitacyjne w m/s^2.
    g = 9.8
    # Konwersja 'angle' na radiany.
    angle = angle * pi / 180
    # Obliczenie pionowegoi poziomego komponentu prdkoci.
    v_h = velocity * cos(angle)
    v_v = velocity * sin(angle)
    # Obliczenie czasu lotu i zasigu.
    tof = 2 * v_v / g
    range = tof * v_h
    return tof, range
