from email import Encoders
from email.Message import Message
from email.MIMEText import MIMEText
from email.MIMEMultipart import MIMEMultipart
from email.MIMENonMultipart import MIMENonMultipart
import mimetypes

class SmartMessage:

    """Uproszczony interfejs dla bibliotek Pythona, ktry potrafi tworzy
    wiadomoci tekstowe i z zacznikami MIME."""

    def __init__(self, fromAddr, toAddrs, subject, body, enc='iso-8859-2'):
        """Zacznij od zaoenia, i bdzie to prosta wiadomo tekstowa
        zgodna z RFC 2822 i bez MIME."""    
        self.msg = Message()
        self.msg.set_payload(body)
        self['Subject'] = subject
        self.setFrom(fromAddr)
        self.setTo(toAddrs)
        self.hasAttachments = False
        self.enc = enc

    def setFrom(self, fromAddr):
        "Ustawia adres nadawcy wiadomoci."
        if not fromAddr or not type(fromAddr)==type(''):
            raise Exception, 'Wiadomo musi mie jednego i tylko jednego nadawc.'
        self['From'] = fromAddr

    def setTo(self, to):
        "Ustawia adresy osb, ktre maj otrzyma wiadomo."
        if not to:
            raise Exception, 'Wiadomo musi mie co najmniej jednego odbiorc.'
        self._addresses(to, 'To')

        #Dodatkowo przechowuj adresy jako list. By moe
        #skorzysta z niej kod, ktry zajmie si wysyaniem wiadomoci.
        self.to = to

    def setCc(self, cc):
        """Ustawia adresy osb, ktre maj otrzyma kopi wiadomoc. cho
        nie jest ona adresowana do nich w sposb bezporedni."""
        self._addresses(cc, 'Cc')

    def addAttachment(self, attachment, filename, mimetype=None):
        "Docza do wiadomoci wskazany plik."

        #Odgadnij gwny i dodatkowy typ MIME na podstawie nazwy pliku.
        if not mimetype:
            mimetype = mimetypes.guess_type(filename)[0]
        if not mimetype:
            raise Exception, "Nie udao si okreli typu MIME dla", filename
        if '/' in mimetype:
            major, minor = mimetype.split('/')
        else:
            major = mimetype
            minor = None

        #Wiadomo bya konstruowana z zaoeniem, i bdzie zawiera
        #tylko i wycznie tekst. Poniewa wiem, e bdzie zawiera
        #co najmniej jeden zacznik, musimy zmieni j na wiadomo
        #wieloczciow i wklei tekst jako pierwsz cz.        
        if not self.hasAttachments:
            body = self.msg.get_payload()
            newMsg = MIMEMultipart()
            newMsg.attach(MIMEText(body,'plain',self.enc))
            #Skopiuj stare nagwki do nowego obiektu.
            for header, value in self.msg.items():
                newMsg[header] = value
            self.msg = newMsg
            self.hasAttachments = True
        subMessage = MIMENonMultipart(major, minor, name=filename)
        subMessage.set_payload(attachment)

        #Zakoduj teksty jako quoted printable natomiast wszystkie 
        #inne typy jako base64.
        if major == 'text':            
            encoder = Encoders.encode_quopri
        else:
            encoder = Encoders.encode_base64
        encoder(subMessage)        

        #Powi fragment MIME z gwn wiadomoci.
        self.msg.attach(subMessage)        

    def _addresses(self, addresses, key):
        """Ustawia zawarto nagwka na podstawie listy przekazanych adresw."""
        if hasattr(addresses, '__iter__'):
            addresses = ', '.join(addresses)
        self[key] = addresses

    #Kilka metod dodatkowych umoliwiajcych traktowanie klasy w podobny
    #sposb, jak klasy Message lub MultipartMessage, stosujc odpowiedni
    #delegacj polece do tych klas.
    def __getitem__(self, key):
        "Zwr nagwek o podanym kluczu."
        return self.msg[key]

    def __setitem__(self, key, value):
        "Ustaw nagwek o wskazanej nazwie."
        self.msg[key] = value

    def __getattr__(self, key):
        return getattr(self.msg, key)

    def __str__(self):
        "Zwr tekstow reprezentacj wiadomoci."
        return self.msg.as_string()

from smtplib import SMTP
class MailServer(SMTP):

    "Bardziej przyjazny dla uytkownika interfejs klasy SMTP."

    def __init__(self, server, serverUser=None, serverPassword=None, port=25):
        "Pocz si z serwerem SMTP."
        SMTP.__init__(self, server, port)
        self.user = serverUser
        self.password = serverPassword
        #Usu znak komentarza z poniszego wiersza, by zobaczy ca wymian komunikatw.
        #self.set_debuglevel(True)

    def sendMessage(self, message):
        "Wylij wiadomo za pomoc serwera SMTP."
        #Niektre serwery wymagaj uwierzytelnienia.
        if self.user:
            self.login(self.user, self.password)

        #Wiadomo zawiera list adresw docelowych, ktre mog zawiera
        #dodatkowe nazwy, na przykad "Jan Kowalski <jan@przyklad.pl>".
        #Niektre serwery pocztowe obsuguj jedynie czyste adresy,
        #wic musimy utworzy wersj, ktra nie zawiera nazw.
        destinations = message.to
        if hasattr(destinations, '__iter__'):
            destinations = map(self._cleanAddress, destinations)
        else:
            destinations = self._cleanAddress(destinations)
        self.sendmail(message['From'], destinations, str(message))

    def _cleanAddress(self, address):
        "Przeksztaca 'Nazwa <email@domena>' na 'email@domena'."
        parts = address.split('<', 1)
        if len(parts) > 1:
            #Ten adres zawiera tak naprawd nazw i adres:
            newAddress = parts[1]
            endAddress = newAddress.find('>')
            if endAddress != -1:                    
                address = newAddress[:endAddress]
        return address

##msg = SmartMessage("Me <me@example.com",
##                   "You <you@example.com>",
##                   "Your picture",
##                   "Here's that picture I took of you.")
##msg.addAttachment(open("photo.jpg").read(), "photo.jpg")
##MailServer("localhost").sendMessage(msg)
