#!/usr/bin/python
from imaplib import IMAP4

class SubjectLister(IMAP4):
    """czy si ze skrzynk IMAP4 i pobiera list tematw wszystkich
    wiadomoci."""

    def __init__(self, server, username, password):
        "czy si z serwerem IMAP."
        IMAP4.__init__(self, server)
        #Usu komentarz z poniszego wiersza, by zobaczy szczegy komunikacji.
        #self.debug = 4
        self.login(username, password)

    def summarize(self, mailbox='Inbox'):
        "Pobiera tematy wszystkich wiadomoci ze wskazanej skrzynki."
        #Polecenie SELECT czyni wskazan skrzynk sprzynk aktualn
        #i zwraca liczb wiadomoci. Kada wiadomo dostpna jest na 
        #podstawie numeru. Jeli skrzynka zawiera 10 wiadomocin
        #to s one ponumerowane od 1 do 10.
        numberOfMessages = int(self._result(self.select(mailbox)))
        
        print '%s wiadomoci w skrzynce "%s":' % (numberOfMessages, mailbox)

        #Polecenie FETCH przyjmuje oddzielon przecinkami list numerw
        #wiadomoci i tekst okrelajcy, ktre czci wiadomoci maj zosta
        #pobrane. W przedstawionym przykadzie potrzenujemy jedynie 
        #nagwka 'Subject', wic stosujemy tekst o nastpujcej treci:
        #'(BODY[HEADER.FIELDS (SUBJECT)])'.
        #
        #Sekcja 6.4.5 dokumentu RFC3501 zawiera szczegowe informacje na temat
        #formatu i elementw tekstu okrelajcego elementy wiadomoci.
        #Aby pobra ca wiadomo w formacie odpowiednim dla analizatora,
        #zastosuj tekst '(RFC822)'.

        subjects = self._result(self.fetch('1:%d' % numberOfMessages,
                                         '(BODY[HEADER.FIELDS (SUBJECT)])'))
        for subject in subjects:
            if hasattr(subject, '__iter__'):
                subject = subject[1]                
                print '', subject[:subject.find('\n')]

    def _result(self, result):
        """Kada metoda z imaplib zwraca list zawierajc kod statusu
        i zbir rzeczywistych danych. Ta metoda dodatkowa zgasza wyjtek,
        jeli kod statusu jest inny od "OK".
        Jeli wszystko jest w porzdku, zwraca uzyskane dane.
        """
        status, result = result
        if status != 'OK':
            raise status, result
        if len(result) == 1:
            result = result[0]
        return result

if __name__ == '__main__':
    import sys
    if len(sys.argv) < 4:
        print 'Uycie: %s [adres serwera IMAP] [uytkownik IMAP] [haso IMAP]' % sys.argv[0]
        sys.exit(0)
    lister = SubjectLister(sys.argv[1], sys.argv[2], sys.argv[3])
    lister.summarize()
