#!/usr/bin/python
from imaplib import IMAP4
import email
import re

#Uywane do przetworzenia odpowiedzi IMAP.
FROM_HEADER = 'From: '
IMAP_UID = re.compile('UID ([0-9]+)')

#Poczenie z serwerem.
server = IMAP4('imap.przyklad.pl')
server.login('[uytkownik]', '[haso]')
server.select('Inbox')

#Pobranie unikatowych identyfikatorw wiadomoci.
uids = server.uid('SEARCH', 'ALL')[1][0].split(' ')
uidString = ','.join(uids)

#Pobierz nagwek From kadej wiadomoci.
headers = server.uid('FETCH', '%s' % uidString,	
                     '(BODY[HEADER.FIELDS (FROM	)])')
for header in headers[1]:
    if len(header) > 1:
        uid, header = header
        #Przetwrz odpowied IMAP na rzeczywisty UID i warto nagwka From.
        match = IMAP_UID.search(uid)
        uid = match.groups(1)[0]

        fromHeader = header[len(FROM_HEADER):].strip()

        #Utwrz skrzynk dla osoby, ktra wysaa wiadomo.
        #Jeli ju istnieje, serwer zgosi bd, ale my go zignorujemy.
        server.create(fromHeader)

        #Skopiuj wiadomo do skrzynki.
        server.uid('COPY', uid, fromHeader)

#Usu wiadomoci ze skrzynki odbiorczej, poniewa zostay przetworzone.
server.uid('STORE', uidString, '+FLAGS.SILENT', '(\\Deleted)')
server.expunge()        
