#!/usr/bin/env python
"""
gui_queue.py

Ten modu wykonuje zadania, ktre pozwalaj unikn problemw z wtkami w systemach Linux i Windows.
Inne moduy mog go stosowa bez adnej dodatkowej wiedzy na temat gtk.
"""

#Kod udostpniony na licencji Python License dla ksiki Beginning Python

import findgtk
import gtk
import random
import socket
import time
from threading import RLock
import timeoutsocket #uywane dla set_timeout()

class gui_queue:
    """Budzi wtek GUI, ktry czyci i wykonuje zadania z kolejki."""
    def __init__(self,gui,listenport=0):
        """Jeli listenport jest rwne 0, tworzymy losowy port do nasuchiwania"""
        self.mylock=RLock()
        self.myqueue=[]
        if listenport==0:
            self.listenport=random.randint(1025,10000)
        else:
            self.listenport=listenport
        print "Lokalna kolejka GUI nasuchuje na porcie %s"%self.listenport
        s=socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        s.bind(("", self.listenport))  
        self.listensocket=s
        self.listensocket.listen(300) #nasuchiwanie aktywnoci
        #time.sleep(15)
        self.gui=gui
        return
    
    def append(self,command,args):
        """
        Metod t moe wykona dowolny wtek.
        """
        #print "zaooenie blokady..."
        self.mylock.acquire()
        self.myqueue.append((command,args))
        #moe nie dziaa poprawnie na komputerze z firewallem ZoneAlarm 
        #lub przy braku poczenia sieciowego...
        s=socket.socket(socket.AF_INET, socket.SOCK_STREAM)

        #Niewielki limit czasu budzi wtek GUI, ale nie powoduje
        #dugich przestojw, gdy wtek jest ju wykonywany.
        #Naley pamita o stosowaniu timeoutsocket i jego
        #wczeniejszym zaadowaniu.
        s.set_timeout(0.01)
        #Obudzenie!
        #print "czenie z portem %d"%self.listenport
        try:
            s=s.connect(("localhost",self.listenport))
        except:
            #ignorowanie limitu czasu
            pass
        #print "Zwolnienie blokady"
        self.mylock.release()
        return

    def clearqueue(self, socket, x):
        """
        Metoda wywoywana tylko przez gwny wtek GUI.
        Pamitaj o zwracaniu wartoci 1.
        """
        #print "Czyszczenie kolejki"
        #cCzy...naley doda wywoanie select.
        newconn,addr=self.listensocket.accept()
        for i in self.myqueue:
            (command,args)=i
            self.gui.handle_gui_queue(command,args)
        self.myqueue=[]
        return 1

class Queued:

    def __init__(self):
        self.gui_queue=gui_queue(self) #nowakolejka GUI
        #Dla starszych pyGTK:
        #gtk.input_add(self.gui_queue.listensocket,
        #              gtk.gdk.INPUT_READ, self.gui_queue.clearqueue)
        #
        #Dla nowszych pyGTK (2.6):
        import gobject
        gobject.io_add_watch(self.gui_queue.listensocket, gobject.IO_IN,
                             self.gui_queue.clearqueue)

    def handle_gui_queue(self, command, args):
        """
        Wywoanie zwrotne uywane przez gui_queue, gdy otrzyma od nas polecenie.
        Polecenie (command) jest cigiem znakw.
        Parametr args zawiera list argumentw polecenia.
        """
        gtk.threads_enter()
        #print "handle_gui_queue"
                
        method = getattr(self, command, None)
        if method:
            apply(method, args)
        else:
            print "Nierozpoznana akcja %s: %s"%(command,args)
        #print "Zakoczenie obsugi kolejki GUI"
        gtk.threads_leave()
        return 1
    
    def gui_queue_append(self,command,args):
        self.gui_queue.append(command,args)
        return 1
