"""
Modu tworzcy potrawy w Pythonie.

Zaimportuj modu a nastpnie wywoaj
makeBreakfast(), makeDinner() lub makeLunch().

"""


__all__ = ['Meal','AngryChefException', 'makeBreakfast', 
    'makeLunch', 'makeDinner', 'Breakfast', 'Lunch', 'Dinner']


# Funkcje pomocnicze.

def makeBreakfast():
    '''Tworzy obiekt Breakfast.'''
    return Breakfast()
    
def makeLunch():
    '''Tworzy obiekt Lunch.'''
    return Lunch()

def makeDinner():
    '''Tworzy obiekt Dinner.'''
    return Dinner()
    
# Klasy wyjtkw.

class SensitiveArtistException(Exception): 
    '''Wyjtek dotyczcy przewraliwionych artystw.
    
    Klasa bazowa dla typw artystycznych.'''
    pass


class AngryChefException(SensitiveArtistException): 
    '''Wyjtek wskazujcy szefa w zym humorze.'''
    pass

    
    
    
class Meal:
    '''Przechowuje jedzenie i picie skadajce si na posiek.
    Zgodnie z zasadami obiektowoci, klasa stosuje metody
    ustawiajce dla jedzenia i picia.
    
    Wywoaj printIt, aby adnie wywietli wartoci.
    '''

    def __init__(self, food='omlet', drink='kawa'):
        '''Inicjalizacja na wartoci domylne.'''
        self.name = 'posiek'
        self.food = food
        self.drink = drink
    
    def printIt(self, prefix=''):
        '''adne wywietlenie danych.'''
        print prefix,'Smaczny',self.name,'czyli',self.food,'i',self.drink
          
    # Metoda ustawiajca dla jedzenia.
    def setFood(self, food='omlet'):
        self.food = food
    
    # Metoda ustawiajca dla picia.    
    def setDrink(self, drink='kawa'):
        self.drink = drink
        
    # Metoda ustawiajca dla nazwy.
    def setName(self, name=''):
        self.name = name
        

class Breakfast(Meal):
    '''Jedzenie i picie zwizane ze niadaniem.'''
        
    def __init__(self):
        '''Inicjalizuj omletem i kaw.'''
        Meal.__init__(self, 'omlet', 'kawa')
        self.setName('niadanie')
        
class Lunch(Meal):
    '''Jedzenie i picie zwizane z lunchem.'''
        
    def __init__(self):
        '''Inicjalizuj kanapk i dinem z tonikiem.'''
        Meal.__init__(self, 'kanapka', 'din z tonikiem')
        self.setName('lunch')

    # Przesania setFood().
    def setFood(self, food='kanapka'):
        if food != 'kanapka' and food != 'omlet':
            raise AngryChefException
        Meal.setFood(self, food)
        
class Dinner(Meal):
    '''Jedzenie i picie zwizane z obiadem.'''
        
    def __init__(self):
        '''Inicjalizuj stekiem i winem.'''
        Meal.__init__(self, 'stek', 'wino')
        self.setName('obiad')

    def printIt(self, prefix=''):
        '''Wywietl opis w jeszcze przyjemniejszy sposb.'''
        print prefix,'Przepyszny',self.name,'czyli',self.food,'i',self.drink       
 
        
def test():
    '''Funkcja testujca.'''
    
    print 'Testowanie moduu Meal.'
    
    # Brak argumentw.
    print 'Testowanie klasy Meal.'
    m = Meal()
    
    m.printIt("\t")
    
    
    m = Meal('jajka i szynka', 'herbata')
    m.printIt("\t")
    
    # Testowanie niadania.
    print 'Testowanie klasy Breakfast.'
    b = Breakfast()
    b.printIt("\t")
    
    b.setName('drugie niadanie')
    b.printIt("\t")
    
    
    # Testowanie obiadu.
    print 'Testowanie klasy Dinner.'
    d = Dinner()
    d.printIt("\t")
    
    
    # Testowanie lunchu.
    print 'Testowanie klasy Lunch.'
    l = Lunch()
    l.printIt("\t")
    
    print 'Wywoanie Lunch.setFood().'
    try:
        l.setFood('hotdog')
    except AngryChefException:
        print "\t",'Szef jest zy. We omlet.'

# Uruchom testy, jeli modu zostanie uruchomiony jako program.        
if __name__ == '__main__':
    test()
