import math
from threading import Thread
import time

class SquareRootCalculator:

    """Klasa wykorzystuje osobny wtek do policzenia wielu pierwiastw kwadratowych.
    Co sekund sprawdza, czy zadanie zostao wykonane."""

    def __init__(self, target):
        """Wcza wtek kalkulatora a nastpnie co pewnien czas
        sprawdza postpy prac."""
        self.results = []
        counter = self.CalculatorThread(self, target)
        print "Wczam wtek kalkulatora..."
        counter.start()
        while len(self.results) < target:
            print "%d pierwiastw kwadratowych policzono do tej pory." % len(self.results)
            time.sleep(1)
        print "Policzono %s pierwiastkw kwadratowych; ostatni to sqrt(%d)=%f" % \
              (target, len(self.results), self.results[-1])
              
    class CalculatorThread(Thread):
        """Osobny wtek wykonujcy odpowiednie obliczenia."""

        def __init__(self, controller, target):
            """Inicjalizuje wtek i dodatkowo tworzy go wtkiem demona
            aby skrypt nie musia oczekiwa na jego zakoczenie."""
            Thread.__init__(self)
            self.controller = controller
            self.target = target
            self.setDaemon(True)

        def run(self):
            """Wylicza pierwiastki kwadratowe od 1 do zadanej wartoci."""
            for i in range(1, self.target+1):
                self.controller.results.append(math.sqrt(i))

if __name__ == '__main__':
    import sys
    limit = None
    if len(sys.argv) > 1:
        limit = sys.argv[1]
        try:
            limit = int(limit)
        except ValueError:
            print "Uycie: %s [liczba pierwiastw kwadratowych do wyliczenia]" \
                  % sys.argv[0]    
    SquareRootCalculator(limit)
