#!/usr/bin/python


class Fridge:
    """Klasa implementuje lodwk, do ktrej mona wstawia lub 
    pobiera produkty pojedynczo lub w grupach.  
    Lodwka przewchowuje informacj o liczbie sztuk kadego produktu.
    Zgosi wyjtek, jeli bdzie prbowao si pobra wicej sztuk produktu 
    ni znajduje si w lodwce.
    Metody:
    has(food_name [, quantity]) - sprawdza, czy produkt food_name znajduje si w lodwce.  Parametr quantity zostanie ustawiony na 1, jeli si go nie przekae.
    has_various(foods) - sprawdza, czy w lodwce znajduj si produkty ze sownika w odpowiedniej liczbie sztuk.
    add_one(food_name) - dodaje do lodwki pojedynczy produkt o nazwie food_name
    add_many(food_dict) - dodaje do lodwki cay sownik produktw
    get_one(food_name) - pobiera z lodwki pojedynczy produkt o nazwie food_name
    get_many(food_dict) - pobiera z lodwki cay sownik produktw
    get_ingredients(food) - jeli przekae si obiekt zawierajcy metod __ingredients__ 
            zostanie uyta metoda get_many, by przetworzy list skadnikw
    """
    
    def __init__(self, items={}):
        """Opcjonalny parametr przyjmuje sownik produktw"""
        if type(items) != type({}):
            raise TypeError, "Obiekt wymaga sownika, ale przekazano %s" % type(items)
        self.items = items
        return

    def __add_multi(self, food_name, quantity):
        """
        __add_multi(food_name, quantity) - dodaje kilka sztuk jednego produktu 
        do listy produktw w lodwce.
        
        Metod naley stosowa tylko wewntrznie po dokonaniu sprawdzania typw.
        """
        if not self.items.has_key(food_name):
            self.items[food_name] = 0
            
        self.items[food_name] = self.items[food_name] + quantity

    def add_one(self, food_name):
        """
        add_one(food_name) - dodaje do lodwki pojedynczy produkt o nazwie food_name
        Zwraca True.
        Zgasza wyjtek TypeError, jeli food_name nie jest cigiem znakw.
        """
        if type(food_name) != type(""):
            raise TypeError, "add_one wymaga cigu znakw, podano %s" % type(food_name)
        else:
            self.__add_multi(food_name, 1)
        
        return True
        
    def add_many(self, food_dict):
        """
        add_many(food_dict) - dodaje cay sownik, w ktrym kluczami s nazwy
            produktw a wartociami liczby sztuk
        Metoda nic nie zwraca.
        Zgasza wyjtek TypeError, jeli food_dict nie jest sownikiem
        """
        
        if type(food_dict) != type({}):
            raise TypeError, "add_many wymaga sownika, podano %s" % food_dict
        
        for item in food_dict.keys():
            self.__add_multi(item, food_dict[item])
        return

    def has(self, food_name, quantity=1):
        """
        has(food_name, [quantity]) - sprawdza, czy produkt food_name znajduje si w lodwce.  Parametr quantity przyjmuje domylnie warto 1.
        Zwraca True, jeli sztuk produktu jest wystarczajco duo; w przeciwnym razie zwraca False.
        """
        
        return self.has_various({food_name:quantity})
        
    def has_various(self, foods):
        """
        has_various(foods) - sprawdza, czy lodwka zawiera wystarczajco duo sztuk
            produktw wymienionych w sowniku foods.
        Zwraca True, jeli sztuk wszystkich produktw jest wystarczajco duo;
        zwraca False, jeli cho jednego produktu jest za mao lub w ogle nie wystpuje.
        """
        
        try:
            for food in foods.keys():
                if self.items[food] < foods[food]:
                    return False
            return True
        except KeyError:
            return False
   
    def __get_multi(self, food_name, quantity):
        """
        __get_multi(food_name, quantity) - usuwa wicej ni jedn sztuk
        produktu. Zwraca liczb usunitych sztuk.
        Zwraca False, jeli nie byo w lodwce wystarczajco duo sztuk
        produktu food_name.
        Metoda przewidziana jest tylko do uytku wewntrznego ju po
        przeprowadzeniu sprawdzania typw.
        """
        
        try:
            if not self.has(food_name, quantity):
                return False
            self.items[food_name] = self.items[food_name] - quantity
        except KeyError:
            return False
        return quantity

    def get_one(self, food_name):
        """
        get_one(food_name) - pobiera z lodwki sztuk produktu food_name.
        Zwraca liczb sztuk produktu.
        Zwraca False, jeli produktu nie ma w lodwce.
        """

        if type(food_name) != type(""):
            raise TypeError, "get_one wymaga cigu znakw, przekazano %s" % type(food_name)
        else:
            result = self.__get_multi(food_name, 1)
        return result

    def get_many(self, food_dict):
        """
        get_many(food_dict) - pobiera z lodwki produktu wskazane w sowniku
        Zwraca sownik ze wszystkimi skadnikami.
        Nic nie zwraca, jeli nie ma wystarczajco duo sztuk produktw w lodwce  
        lub nie przekazano sownika.
        """
        
        if self.has_various(food_dict):
            foods_removed = {}
            for item in food_dict.keys():
                foods_removed[item] = self.__get_multi(item, food_dict[item])
            return foods_removed
        
    def get_ingredients(self, food):
        """
        get_ingredients(food) - jeli przekazano obiekt zawierajcy metod __ingredients__ 
            zostanie wywoana metoda get_many z list skadnikw.
        """
        try:
            ingredients = self.get_many(food.__ingredients__())
        except AttributeError:
            return False
        
        if ingredients != False:
            return ingredients
   

class Omelet:
    """Klasa reprezentuje omlet. Omlet moe znajdowa si w jednym
    z dwch stanw: przygotowanych skadnikw i wykonanym.
    Interfejs definiowany przez klas:
    get_kind() - zwraca cig znakw z nazw rodzaju omletu
    set_kind(kind) - ustawia rodzaj omletu
    set_new_kind(kind, ingredients) - tworzy omlet
    mix() - wywoywana po pobraniu wszystkich skadnikw z lodwki
    cook() - przygotowuje omlet ze skadnikw
    """
    def __init__(self, kind="serowy"):
        """__init__(self, kind="serowy")
        Inicjalizuje klas Omelet.
        Domylnie przyjmuje tworzenie omletu serowego.
        """
        self.set_kind(kind)
        return


    def __ingredients__(self):
        """Metoda wewntrzna wywoywana przez lodwk lub inny kod 
        wymagajcy dostpu do skadnikw omletu.
        """
        return self.needed_ingredients
        
    def get_kind(self):
        return self.kind
    
    def set_kind(self, kind):
        possible_ingredients = self.__known_kinds(kind)
        if possible_ingredients == False:
            return False
        else:
            self.kind = kind
            self.needed_ingredients = possible_ingredients
        
    def set_new_kind(self, name, ingredients):
        self.kind = name
        self.needed_ingredients = ingredients
        return

    def __known_kinds(self, kind):
        if kind == "serowy":
            return {"jajko":2, "mleko":1, "ser":1}
        elif kind == "grzybowy":
            return {"jajko":2, "mleko":1, "ser":1, "grzyb":2}
        elif kind == "cebulowy":
            return {"jajko":2, "mleko":1, "ser":1, "cebula":1}
        else:
            return False

    def get_ingredients(self, fridge):
        self.from_fridge = fridge.get_ingredients(self)
        
    def mix(self):
        for ingredient in self.from_fridge.keys():
            print "Mieszanie %d %s, by powsta omlet %s" % (self.from_fridge[ingredient], ingredient, self.kind)
        self.mixed = True

    def make(self):
        if self.mixed == True:
            print "Przygotowanie omletu %s!" % self.kind
            self.cooked = True

