"Menedżer kontekstu, który śledzi wejście i wyjście z bloku każdej instrukcji with"

class TraceBlock:
    def message(self, arg):
        print('wykonywanie ' + arg)

    def __enter__(self):
        print('[rozpoczęcie bloku with]')
        return self

    def __exit__(self, exc_type, exc_value, exc_tb):
        if exc_type is None:
            print('[normalne wyjście]\n')
        else:
            print(f'[przekazanie wyjątku: {exc_type}]')
            return False

if __name__ == '__main__':
    with TraceBlock() as action:
        action.message('test 1')
        print('osiągnięty')

    with TraceBlock() as action:
        action.message('test 2')
        raise TypeError
        print('nie został osiągnięty')

