import time

def timer(label='', trace=True):                  # Dla argumentów dekoratora: zachowanie argumentów
    class Timer:
        def __init__(self, func):                 # Dla @: zachowanie udekorowanej funkcji
            self.func    = func
            self.alltime = 0
        def __call__(self, *args, **kargs):       # Dla wywołań: wywołanie oryginalnej funkcji
            start   = time.perf_counter()
            result  = self.func(*args, **kargs)
            elapsed = time.perf_counter() - start
            self.alltime += elapsed
            if trace:
                if label: print(label, end=' ')
                print(f'{self.func.__name__}: {elapsed:.5f}, {self.alltime:.5f}')
            return result
    return Timer

