class Person:
    def __init__(self, name, job=None, pay=0):
        self.name = name
        self.job  = job
        self.pay  = pay
    def lastName(self):
        return self.name.split()[-1]
    def giveRaise(self, percent):
        self.pay = int(self.pay * (1 + percent))
    def __repr__(self):
        return f'[Person: {self.name} ${self.pay:,}]'

class Manager(Person):
    def __init__(self, name, pay):                     # Zredefiniowanie konstruktora
        Person.__init__(self, name, 'manager', pay)    # Wykonanie oryginalnej metody z łańcuchem 'manager'
    def giveRaise(self, percent, bonus=.10):
        Person.giveRaise(self, percent + bonus)

if __name__ == '__main__':
    bob = Person('Robert Zielony')
    anna = Person('Anna Czerwona', job='dev', pay=100000)
    print(bob)
    print(anna)
    print(bob.lastName(), anna.lastName())
    anna.giveRaise(.10)
    print(anna)
    tom = Manager('Tomasz Czarny', 50000)                   # Nazwa sugerowana (ustawiana) za pomocą klasy
    tom.giveRaise(.10)
    print(tom.lastName())
    print(tom)

