# Kod nieumieszczony w książce: pobieranie wszystkich atrybutów za pomocą __getattribute__.
# Wyjątkiem są operacje wbudowane takie jak wyświetlanie - te operacje pomijają instancję...
# Należy unikać pętli z object.__getattribute__.

from person_10 import Person                        # Wczytanie bieżącego obiektu Person

class Manager:
    def __init__(self, name, pay):
        self.person = Person(name, 'manager', pay)      # Osadzenie obiektu Person

    def giveRaise(self, percent, bonus=.10):
        object.__getattribute__(self, 'person').giveRaise(percent + bonus) 

    def __getattribute__(self, attr):
        print('=>', attr)
        if attr == 'giveRaise':
            return object.__getattribute__(self, attr)
        else:
            return getattr(object.__getattribute__(self, 'person'), attr)

    # Umieść znacznik komentarza przed kolejnymi wierszami, aby przetestować pobieranie __repr__ : użyty domyślny obiekt 
    def __repr__(self):
        print('-> repr')
        return str(object.__getattribute__(self, 'person'))

if __name__ == '__main__':
    bob = Person('Robert Zielony')
    anna = Person('Anna Czerwona', job='programista', pay=100000)
    print(bob)
    print(anna)
    print(bob.lastName(), anna.lastName())
    anna.giveRaise(.10)
    print(anna)
    tom = Manager('Tomasz Czarny', 50000)               # Nazwa stanowiska ustawiona przez klasę
    tom.giveRaise(.10)
    print(tom.lastName())
    print(tom)


