"Zastosowanie dowolnego dekoratora do wszystkich metod klasy przy użyciu metaklasy"

from types import FunctionType
from decorators import tracer, timer

def decorateAll(decorator):
    class MetaDecorate(type):
        def __new__(meta, classname, supers, classdict):
            for attr, attrval in classdict.items():
                if type(attrval) is FunctionType:
                    classdict[attr] = decorator(attrval)
            return type.__new__(meta, classname, supers, classdict)
    return MetaDecorate

class Person(metaclass=decorateAll(tracer)):       # Użycie metaklasy
    def __init__(self, name, pay):                 # Przekazanie dowolnego dekoratora funkcji
        self.name = name
        self.pay  = pay
    def giveRaise(self, percent):
        self.pay *= (1.0 + percent)
    def lastName(self):
        return self.name.split()[-1]

def tester(aPerson):
    anna = aPerson('Anna Czerwona', 100_000)
    bob = aPerson('Robert Zielony', 50_000)
    print(f'{anna.name=}, {bob.name=}')
    anna.giveRaise(.10) 
    print(f'{anna.pay=:,.2f}')
    print('Nazwiska:', anna.lastName(), bob.lastName())

if __name__ == '__main__': tester(Person)

