from importlib import import_module
def xprint(msg):
    x, y = msg.split()
    print(x.ljust(10), y)

mods = ['access_builtins_' + scheme
    for scheme in ('inline_direct', 'mixin_direct', 'mixin_getattr', 'mixin_desc')]

for modname in mods:
    modobj = import_module(modname)
    print(modobj.__name__.center(48, '-'))
    
    @modobj.Private('sum')                        # Dodanie '__add__' w celu zobaczenie czy i jak jest sprawdzany
    class Tally:                                  # Wyłączenie @ w celu zobaczenie domyślnego przypadku
        def __init__(self):
            self.sum = 0
        def __add__(self, add):
            self.sum += add

    X = Tally()

    try:    X.sum
    except: xprint('sum nie zadziałało')
    else:   xprint('sum zadziałało')

    try:    X.__add__(5)
    except: xprint('__add__ nie zadziałało')
    else:   xprint('__add__ zadziałało')

    try:    X + 5
    except: xprint('+ nie zadziałało')
    else:   xprint('+ zadziałało')

    try:    assert X._onInstance__wrapped.sum == 10
    except: xprint('__wrapped nie zadziałało')
    else:   xprint('__wrapped zadziałało')

    try:    assert X._wrapped.sum == 10
    except: xprint('_wrapped nie zadziałało')
    else:   xprint('_wrapped zadziałało')


"""
==============================================================================================
Oczekiwany rezultat


# BEZ __add__

$ py3 access_builtins_TEST.py
---------access_builtins_inline_direct----------
sum        nie zadziałało
__add__    zadziałało
+          zadziałało
__wrapped  zadziałało
_wrapped   nie zadziałało
----------access_builtins_mixin_direct----------
sum        nie zadziałało
__add__    zadziałało
+          zadziałało
__wrapped  nie zadziałało
_wrapped   zadziałało
---------access_builtins_mixin_getattr----------
sum        nie zadziałało
__add__    zadziałało
+          zadziałało
__wrapped  zadziałało
_wrapped   nie zadziałało
-----------access_builtins_mixin_desc-----------
sum        nie zadziałało
__add__    zadziałało
+          zadziałało
__wrapped  zadziałało
_wrapped   nie zadziałało


# Z __add__

$ py3 access_builtins_TEST.py
---------access_builtins_inline_direct----------
sum        nie zadziałało
__add__    zadziałało
+          zadziałało
__wrapped  zadziałało
_wrapped   nie zadziałało
----------access_builtins_mixin_direct----------
sum        nie zadziałało
__add__    zadziałało
+          zadziałało
__wrapped  nie zadziałało
_wrapped   zadziałało
---------access_builtins_mixin_getattr----------
sum        nie zadziałało
__add__    nie zadziałało
+          nie zadziałało
__wrapped  nie zadziałało
_wrapped   nie zadziałało
-----------access_builtins_mixin_desc-----------
sum        nie zadziałało
__add__    nie zadziałało
+          nie zadziałało
__wrapped  nie zadziałało
_wrapped   nie zadziałało


# BEZ DEKORATORA

$ py3 access_builtins_TEST.py
---------access_builtins_inline_direct----------
sum        zadziałało
__add__    zadziałało
+          zadziałało
__wrapped  nie zadziałało
_wrapped   nie zadziałało
----------access_builtins_mixin_direct----------
sum        zadziałało
__add__    zadziałało
+          zadziałało
__wrapped  nie zadziałało
_wrapped   nie zadziałało
---------access_builtins_mixin_getattr----------
sum        zadziałało
__add__    zadziałało
+          zadziałało
__wrapped  nie zadziałało
_wrapped   nie zadziałało
-----------access_builtins_mixin_desc-----------
sum        zadziałało
__add__    zadziałało
+          zadziałało
__wrapped  nie zadziałało
_wrapped   nie zadziałało

==============================================================================================
"""
