"Permutacja sekwencji - jako lista lub generator wartości"

def permute1(seq):
    if not seq:                               # Mieszanie kolejności elementów dowolnej sekwencji: lista
        return [seq]                          # Pusta sekwencja
    else:
        res = []
        for i in range(len(seq)):
            rest = seq[:i] + seq[i+1:]        # Usuń bieżący węzeł
            for x in permute1(rest):          # Permutuj pozostałe elementy
                res.append(seq[i:i+1] + x)    # Dodaj węzeł na początku
        return res

def permute2(seq):
    if not seq:                               # Mieszanie dowolnej sekwencji: generator
        yield seq                             # Pusta sekwencja
    else:
        for i in range(len(seq)):
            rest = seq[:i] + seq[i+1:]        # Usuń bieżący węzeł
            for x in permute2(rest):          # Permutuj pozostałe elementy
                yield seq[i:i+1] + x          # Dodaj węzeł na początku 
