def Tracer(aClass):                                   # W momencie dekoracji @
    class Wrapper:
        def __init__(self, *args, **kargs):           # W momencie tworzenia instancji
            self.fetches = 0
            self.wrapped = aClass(*args, **kargs)     # Użycie nazwy z zakresu funkcji zawierającej
        def __getattr__(self, attrname):
            print('Trace: ' + attrname)               # Przechwytuje wszystko oprócz własnych atrybutów
            self.fetches += 1
            return getattr(self.wrapped, attrname)    # Delegacja do opakowanego obiektu
    return Wrapper


if __name__ == '__main__':

    @Tracer
    class Hack:                                  # Hack = Tracer(Hack)
        def display(self):                       # Klasa Hack ponownie dowiązana do Wrapper
            print('Hakować!' * 3)

    @Tracer
    class Person:                                # Person = Tracer(Person)
        def __init__(self, name, hours, rate):   # Wrapper pamięta Person
            self.name = name
            self.hours = hours
            self.rate = rate
        def pay(self):                           # Próby dostępu spoza klasy są śledzone
            return self.hours * self.rate        # Próby dostępu z wewnątrz metody nie są śledzone

    work = Hack()                                # Wywołuje Wrapper()
    work.display()                               # Wywołuje __getattr__
    print([work.fetches])

    print()
    bob = Person('Robert', 40, 50)               # Obiekt bob jest tak naprawdę instancją Wrapper
    print(bob.name)                              # Wrapper osadza instancję Person
    print(bob.pay())

    print()
    anna = Person('Anna', rate=100, hours=60)     # Obiekt anna jest inną instancją Wrapper
    print(anna.name)                              # Z inną klasą Person
    print(anna.pay())

    print()
    print(bob.name)                              # Obiekt bob ma inny stan
    print(bob.pay())
    print('wywołanie:', [bob.fetches, anna.fetches])  # Atrybuty klasy Wrapper nie są śledzone

