class DescSquare:
    def __init__(self, start):                  # Każdy deskryptor ma własny stan
        self.value = start

    def __get__(self, instance, owner):         # Przy pobieraniu atrybutów
        return self.value ** 2

    def __set__(self, instance, value):         # Przy przypisywaniu atrybutów
        self.value = value                      # Brak usuwania i dokumentacji

class Client1:
    X = DescSquare(3)          # Przypisanie instancji deskryptora do atrybutu klasy

class Client2:
    X = DescSquare(32)         # Inna instancja w innej klasie klienta
                               # Można także utworzyć kod dwóch instancji tej samej klasy
c1 = Client1()
c2 = Client2()

print(c1.X)                    # 3 ** 2
c1.X = 4
print(c1.X)                    # 4 ** 2
print(c2.X)                    # 32 ** 2 (1024)

