"""
classtree.py: Przechodzenie w górę drzewa dziedziczenia za pomocą łączy przestrzeni nazw, 
wyświetla wyższe klasy nadrzędne z odpowiednim wcięciem.
"""

def classtree(cls, indent):
    print('.' * indent + cls.__name__)     # Wyświetlenie tu nazwy klasy
    for supercls in cls.__bases__:         # Rekurencja po wszystkich klasach nadrzędnych
        classtree(supercls, indent+3)      # Może odwiedzić klasę nadrzędną więcej niż raz

def instancetree(inst):
    print('Drzewo', inst)                 # Pokazanie instancji
    classtree(inst.__class__, 3)           # Przejście do jej klasy

def selftest():
    class A:      pass
    class B(A):   pass
    class C(A):   pass
    class D(B,C): pass
    class E:      pass
    class F(D,E): pass
    instancetree(B())
    instancetree(F())

if __name__ == '__main__': selftest()

