# Przykłady async.  Jak wspomniano w książce, skopiuj i wklej fragmenty kodu albo przed znacznik komenatrza przed częściami, któryvh nie chcesz uruchamiać, albo uruchom całość.



import time, asyncio
def now(): 
    return time.strftime('[%H:%M:%S]')      # Czas lokalny w formacie godzina:minuta:sekunda



print('1-----------------------------------------------------')



def producer(label):
    time.sleep(2)                                     # Zatrzymanie na dwie sekundy - blokowanie
    return f'Wszystko gotowe, {label}, {now()}'       # I zwrócenie wyniku

def main():
    print('Start =>', now())
    print(producer(f'zadanie sekwencyjne nr 1'))          # Uruchomienie trzech kroków w sekwencji
    print(producer(f'zadanie sekwencyjne nr 2'))          # Oczekiwanie na zakończenie każdego kroku
    print(producer(f'zadanie sekwencyjne nr 3'))          # Zanim zostaną wykonane inne zadania
    print('Stop  =>', now())

main()



print('2-----------------------------------------------------')



async def producer(label):                     # await wymaga async
    await asyncio.sleep(2)                     # Wywołanie nieblokującego/mogącego czekać uśpienia
    return f'Wszystko gotowe, {label}, {now()}'       # Wynik wyrażenia await

async def main():
    print('Start =>', now())
    task1 = asyncio.create_task(producer(f'zadanie async nr 1'))
    task2 = asyncio.create_task(producer(f'zadanie async nr 2'))
    task3 = asyncio.create_task(producer(f'zadanie async nr 3'))
    print(await task1) 
    print(await task2) 
    print(await task3)                         # Oczekiwanie na zakończenie zadań
    print('Stop  =>', now())

asyncio.run(main())                            # Rozpoczęcie pętli zdarzeń



print('3-----------------------------------------------------')



async def producer(label):
    await asyncio.sleep(2)
    return f'Wszystko gotowe, {label}, {now()}'

async def main():
    print('Start =>', now())
    tasks = []
    for i in range(3):
        tasks.append(asyncio.create_task(producer(f'zadanie async nr {i+1}')))
    for task in tasks:
        print(await task)
    print('Stop =>', now())

asyncio.run(main())



print('4-----------------------------------------------------')



async def producer(label):
    await asyncio.sleep(2)
    return f'Wszystko gotowe, {label}, {now()}'

async def main():
    print('Start =>', now())
    coros = [producer(f'zadanie async nr {i+1}') for i in range(3)]
    for nextdone in asyncio.as_completed(coros):
        print(await nextdone)
    print('Stop =>', now())

asyncio.run(main())



print('5-----------------------------------------------------')



async def producer(label):
    await asyncio.sleep(2)
    return f'Wszystko gotowe, {label}, {now()}'

async def main():
    print('Start =>', now())
    coro1 = producer(f'zadanie async nr 1')
    coro2 = producer(f'zadanie async nr 2')
    coro3 = producer(f'zadanie async nr 3')
    results = await asyncio.gather(coro1, coro2, coro3)
    print(results) 
    print('Stop =>', now())

asyncio.run(main())



print('6-----------------------------------------------------')



async def producer(label):
    await asyncio.sleep(2)
    return f'Wszystko gotowe, {label}, {now()}'

async def main():
    print('Start =>', now())
    print(await asyncio.gather(*[producer(f'zadanie async nr {i+1}') for i in range(3)]))
    print('Stop =>', now())

asyncio.run(main())



print('7-----------------------------------------------------')



async def producer(label):
    await asyncio.sleep(2)
    return f'Wszystko gotowe, {label}, {now()}'

async def main():
    print('Start =>', now())
    async with asyncio.TaskGroup() as tg:
        tasks = [tg.create_task(producer(f'zadanie async nr {i+1}')) for i in range(3)]
    for task in tasks:
        print(task.result())
    print('Stop =>', now())

asyncio.run(main())



print('8-----------------------------------------------------')



async def producer(label):
    for i in range(3):
        await asyncio.sleep(2)
        yield f'Wszystko gotowe, {label} {i+1}, {now()}'

async def main():
    print('Start =>', now())
    async for reply in producer('zadanie async nr'):
        print(reply)
    print('Stop =>', now())

asyncio.run(main())

