"Dziedziczenie metod, pomijanie sprawdzania"

traceMe = False
def trace(*args):
    if traceMe: print('[' + ' '.join(map(str, args)) + ']')

class BuiltinsMixin:
    def __add__(self, other):
        return self._wrapped + other                          # Założenie, że jest atrybut _wrapped
    def __str__(self):                                        # Ominięcie __getattr__
        return str(self._wrapped)
    def __getitem__(self, index):
        return self._wrapped[index]
    def __call__(self, *args, **kargs):
        return self._wrapped(*args, **kargs)
    # Plus any others needed

def accessControl(failIf):
    def onDecorator(aClass):
        class onInstance(BuiltinsMixin):
            def __init__(self, *args, **kargs):
                self._wrapped = aClass(*args, **kargs)

            def __getattr__(self, attr):
                trace('pobranie:', attr)
                if failIf(attr):
                    raise TypeError('pobieranie atrybutu prywatnego, ' + attr)
                else:
                    return getattr(self._wrapped, attr)

            def __setattr__(self, attr, value):
                trace('ustawienie:', attr, value)
                if attr == '_wrapped':
                    self.__dict__[attr] = value
                elif failIf(attr):
                    raise TypeError('modyfikacja atrybutu prywatnego, ' + attr)
                else:
                    setattr(self._wrapped, attr, value)
        return onInstance
    return onDecorator

def Private(*attributes):
    return accessControl(failIf=(lambda attr: attr in attributes))

def Public(*attributes):
    return accessControl(failIf=(lambda attr: attr not in attributes))

