"Dziedziczenie deskryptorów, uruchamianie walidacji"

traceMe = False
def trace(*args):
    if traceMe: print('[' + ' '.join(map(str, args)) + ']')

class BuiltinsMixin:
    class ProxyDesc:                                          # Definicja deskryptora
        def __init__(self, attrname):
            self.attrname = attrname
        def __get__(self, instance, owner):
            return instance.__getattr__(self.attrname)        # Uruchomienie walidacji

    builtins = ['add', 'str', 'getitem', 'call']              # I inne metody
    for attr in builtins:
        exec(f'__{attr}__ = ProxyDesc("__{attr}__")')         # Utworzenie deskryptorów

def accessControl(failIf):
    def onDecorator(aClass):
        class onInstance(BuiltinsMixin):                      # Dziedziczenie deskryptorów
            def __init__(self, *args, **kargs):
                self.__wrapped = aClass(*args, **kargs)

            def __getattr__(self, attr):
                trace('pobranie:', attr)
                if failIf(attr):
                    raise TypeError('pobranie atrybutu prywatnego:' + attr)
                else:
                    return getattr(self.__wrapped, attr)

            def __setattr__(self, attr, value):
                trace('ustawienie:', attr, value)
                if attr == '_onInstance__wrapped':
                    self.__dict__[attr] = value
                elif failIf(attr):
                    raise TypeError('modyfikacja atrybutu prywatnego:, ' + attr)
                else:
                    setattr(self.__wrapped, attr, value)
        return onInstance
    return onDecorator

def Private(*attributes):
    return accessControl(failIf=(lambda attr: attr in attributes))

def Public(*attributes):
    return accessControl(failIf=(lambda attr: attr not in attributes))

