# Ładowanie wszystkich kolorów do pamięci na raz
color_counts = {}

with open('all-favorite-colors.txt') as favorite_colors_file:
    favorite_colors = favorite_colors_file.read().splitlines()  # <1>

for color in favorite_colors:
    if color in color_counts:
        color_counts[color] += 1
    else:
        color_counts[color] = 1


# Ładowanie do pamięci pojedynczego koloru
color_counts = {}

with open('all-favorite-colors.txt') as favorite_colors_file:
    for color in favorite_colors_file:  # <1>
        color = color.strip()  # <2>

        if color in color_counts:
            color_counts[color] += 1
        else:
            color_counts[color] = 1


# Używanie zbioru do przechowywania tylko unikalnych kolorów
all_colors = set()

with open('all-favorite-colors.txt') as favorite_colors_file:
    for line in favorite_colors_file:  # <1>
        all_colors.add(line.strip())  # <2>

print('Amber Waves of Grain' in all_colors)  # <3>
