#! /usr/bin/env python3
"""l_na_c: modul konwersji liczb na nazwy: zawiera funkcje liczby_na_nazwy. Moze byc uzywany jako skrypt. 
Uzycie jako skrypt: l_na_n liczba 
(Zamienia liczbe na nazwe w jezyku polskim)
liczba: liczba calkowita z zakresu 0 - 999.999.999.999.999 (kropki sa opcjonalne)
przyklad: l_na_c 10.003.103
		dla 10.003.103 nazwa to dziesiec milionow trzy tysiace sto trzy
"""
import sys, string, argparse

# mapowania konwersji
_liczby_1_do_9 = {'0': '', '1': 'jeden', '2':'dwa', '3':'trzy', '4':'cztery', '5':'piec', '6':'szesc', '7':'siedem', '8':'osiem', '9':'dziewiec'}
_liczby_10_do_19 = {'0': 'dziesiec', '1': 'jedenascie', '2':'dwanascie', '3':'trzynascie', '4':'czternascie', '5':'pietnascie', '6':'szesnascie', '7':'siedemnascie', '8':'osiemnascie', '9':'dziewietnascie'}
_liczby_20_do_90 = {'2': 'dwadziescia', '3': 'trzydziesci', '4':'czterdziesci', '5':'piecdziesiat', '6':'szescdziesiat', '7':'siedemdziesiat', '8':'osiemdziesiat', '9':'dziewiecdziesiat'}
_liczby_100_do_900 = {'1': 'sto', '2': 'dwiescie', '3': 'trzysta', '4':'czterysta', '5':'piecset', '6':'szescset', '7':'siedemset', '8':'osiemset', '9':'dziewiecset'}
_lista_rzedow_wielkosci = [(0, ''), (3, 'tysiace'), (6, 'miliony'), (9, 'miliardy'), (12, 'biliony'), (15, '')]

def liczby_na_nazwy(liczba):
	"""liczby_na_nazwy(liczba): zamienia liczbe na polska nazwe"""
	if liczba == "0":
		return "zero"
	liczba = liczba.replace(".", "")
	dlugosc_liczby = len(liczba)
	max_cyfr = _lista_rzedow_wielkosci[-1][0]
	
	if dlugosc_liczby > max_cyfr:
		return "Potrafie obsluzyc tylko liczby do {0} cyfr".format(max_cyfr)

	liczba = '00' + liczba
	nazwa = ''
	for rzad, nazwa_rzedu in _lista_rzedow_wielkosci:
		if rzad >= dlugosc_liczby:
			return nazwa
		else:
			setki, dziesiatki, jednosci = liczba[-rzad-3], liczba[-rzad-2], liczba[-rzad-1]
			if not (setki == dziesiatki == jednosci == '0'):
				nazwa = _obsluz_1_do_999(setki, dziesiatki, jednosci) + nazwa_rzedu + nazwa
				
def _obsluz_1_do_999(setki, dziesiatki, jednosci):
	if setki == '0':
		return _obsluz_1_do_99(dziesiatki, jednosci)
	else:
		return _liczby_100_do_900[setki] + _obsluz_1_do_99(dziesiatki, jednosci)
		
def _obsluz_1_do_99(dziesiatki, jednosci):
	if dziesiatki == '0':
		return _liczby_1_do_9[jednosci]
	elif dziesiatki == '1':
		return _liczby_10_do_19[jednosci]
	else: 
		return _liczby_20_do_90[dziesiatki] + " " + _liczby_1_do_9[jednosci]
		
def test():
	wartosci = sys.stdin.read().split()
	for wartosc in wartosci:
		print("{0} = {1}".format(wartosc, liczby_na_nazwy(wartosc)))
		
def main():
	parser = argparse.ArgumentParser(usage=__doc__)
	parser.add_argument("num", nargs='*')
	parser.add_argument("-t", "--test", dest="test", action='store_true', default="False", help="Tryb testu: czyta z stdin")
	
	args = parser.parse_args()
	if args.test:
		test()
	else:
		try:
			wynik = liczby_na_nazwy(args.num[0])
		except KeyError:
			parser.error("Argument zawiera znaki inne niz cyfry")
		else:
			print("dla {0} nazwa to {1}".format(args.num[0], wynik))
	
	print(liczby_na_nazwy(sys.argv[1]))
	
if __name__ == "__main__":
	main()
else:
	print("l_na_n doladowane jako modul")