# Python. Analiza danych - wydanie trzecie


**Gromadź, przetwarzaj, analizuj i wizualizuj dane, a także twórz modele za pomocą języka Python**

## Czego dotyczy ta książka?
Analiza danych pozwala generować wartość z danych mało- i wielkoskalowych poprzez odkrywanie wzorów i trendów, natomiast Python stanowi jedno z najpopularniejszych narzędzi do analizowania zróżnicowanych typów danych. Niniejsza książka przygotuje Cię do stosowania Pythona w analizie danych poprzez zaprezentowanie poszczególnych etapów i metodologii analizy danych, a także nauczysz się korzystać z nowoczesnych bibliotek środowiska Python w procesie tworzenia wydajnych potoków danych.

W niniejszej książce zostały poruszone następujące ekscytujące tematy: 
* Poznaj danetykę i jej różne modele procesu
* Manipuluj danymi za pomocą bibliotek NumPy i pandas umożliwiającym gromadzenie i oczyszczanie danych, a także rozwiązywanie kwestii brakujących wartości
* Twórz interaktywne wizualizacje za pomocą bibliotek Matplotlib, seaborn i Bokeh
* Odczytuj, przetwarzaj i zapisuj dane w różnych formatach
* Zajmuj się wstępnym przetwarzaniem danych i inżynierią cech za pomocą bibliotek pandas oraz scikit-learn

## Instrukcja
Wszystkie listingi umieszczone są w odpowiednich katalogach, np. Rozdział02.

Listing wygląda następująco:
```
# Tworzy tablicę
import numpy as np
a = np.array([2,4,6,8,10])

print(a)
```

**Dla kogo jest przeznaczona ta książka?**
Książka ta jest przeznaczona dla analityków danych, analityków biznesowych, statystyków i danetyków pragnących nauczyć się wykorzystywania Pythona w analizie danych. Zastosowane w tej książce praktyczne podejście przyda się również studentom i pracownikom szkół wyższych pragnącym podszkolić się lub przekazywać wiedzę o analizie danych w Pythonie. Przydatna okaże się znajomość matematyki na poziomie podstawowym oraz pewna biegłość w Pythonie.

Poniższa lista zawiera oprogramowanie i sprzęt wymagane do uruchomienia listingów opisanych w poszczególnych rozdziałach (1.-14.).

### Lista oprogramowania i sprzętu

| Rozdział  | Wymagane oprogramowanie                   | Wymagany system operacyjny                        |
| -------- | ------------------------------------| -----------------------------------|
| 1.        | Python 3.7 z najnowszym środowiskiem Anaconda                   | Windows, Mac OS X i Linux (dowolne) |
| 2.        | Biblioteka NumPy do obliczeń numerycznych             | Windows, Mac OS X i Linux (dowolne) |
| 2.        | Biblioteka pandas do analizy danych             | Windows, Mac OS X i Linux (dowolne) |
| 3.        | Biblioteka SciPy do obliczeń naukowych            | Windows, Mac OS X i Linux (dowolne) |
| 5.        | Biblioteka Matplotlib do wizualizacji danych           | Windows, Mac OS X i Linux (dowolne) |
| 5.        | Biblioteka seaborn do wizualizacji danych           | Windows, Mac OS X i Linux (dowolne) |
| 5.        | Biblioteka Bokeh do wizualizacji danych            | Windows, Mac OS X i Linux (dowolne) |
| 6.        | Biblioteka PyMySQL do łączenia Pythona z bazą danych MySQL           | WWindows, Mac OS X i Linux (dowolne) |
| 6.        | Biblioteka mysql-connector do łączenia Pythona z bazą danych MySQL           | Windows, Mac OS X i Linux (dowolne) |
| 6.        | Biblioteka PyMongo do łączenia Pythona z bazą danych MongoDB          | Windows, Mac OS X i Linux (dowolne) |
| 6.        | Biblioteka cassandra-driver do łączenia Pythona z bazą danych Cassandra            | Windows, Mac OS X i Linux (dowolne) |
| 6.        | Biblioteka redis do łączenia Pythona z bazą danych Redis           | Windows, Mac OS X i Linux (dowolne) |
| 12.        | Biblioteka przetwarzania języka naturalnego scikit-learn             | Windows, Mac OS X i Linux (dowolne) |
| 12.       | Biblioteka przetwarzania języka naturalnego NLTK            | Windows, Mac OS X i Linux (dowolne) |
| 12.       | Biblioteka przetwarzania języka naturalnego SpaCy             | Windows, Mac OS X i Linux (dowolne) |
| 13.       | Biblioteka przetwarzania obrazów OpenCV           | Windows, Mac OS X i Linux (dowolne) |
| 14.        | Bibliteka Dask do przetwarzania równoległego        | Windows, Mac OS X i Linux (dowolne) |


Dostępny jest także plik PDF (w języku angielskim) zawierający kolorowe zrzuty ekranów/schematy wykorzystane w książce. [Kliknij, aby go pobrać](https://static.packt-cdn.com/downloads/9781789955248_ColorImages.pdf).


### Powiązane produkty <książki, które mogą Cię zainteresować>
* Practical Data Analysis Using Jupyter Notebook [[Packt]](https://www.packtpub.com/product/practical-data-analysis-using-jupyter-notebook/9781838826031) [[Amazon]](https://www.amazon.com/dp/1838826033)

* Essential Statistics for Non-STEM Data Analysts [[Packt]](https://www.packtpub.com/product/essential-statistics-for-non-stem-data-analysts/9781838984847) [[Amazon]](https://www.amazon.com/dp/1838984844)

## Informacje o autorach
**Avinash Navlani**
ma ponad ośmioletnie doświadczenie w dziedzinach danetyki  i sztucznej inteligencji. Obecnie piastuje stanowiska starszego danetyka i zajmuje się usprawnianiem produktów oraz usług dla klientów za pomocą zaawansowanej analizy, wdrażania narzędzi do analizowania danych wielkoskalowych , tworzenia i usprawniania modeli, a także wprowadzania przydatnych zestawów danych. Wcześniej był wykładowcą akademickim, szkolącym studentów w takich zagadnieniach danetyki jak zastosowania analityczne Pythona, wydobywanie danych, uczenie maszynowe, zarządzanie bazami danych i bazy danych NoSQL. Avinash jest zaangażowany w wiele danetycznych projektów badawczych, a także jest zapraszany w Indiach jako główny prelegent na wielu konferencjach.

**Armando Fandango**
tworzy produkty wykorzystujące sztuczną inteligencję dzięki swojej zaawansowanej wiedzy z dziedzin uczenia głębokiego, uczenia maszynowego, uczenia rozproszonego czy metod obliczeniowych i pełnił wiele odpowiedzialnych ról kierowniczych jako główny danetyk i prezes, zarówno w młodych firmach, jak i dużych przedsiębiorstwach. Służył radą w różnych nowoczesnych firmach wykorzystujących sztuczną inteligencję. Armando napisał takie książki, jak Python Data Analysis - Second Edition czy Mastering Tensorflow (Pact Publishing). Jest także autorem publikacji badawczych w międzynarodowych dziennikach i na konferencjach.

**Ivan Idris**
ma tytuł magistra fizyki eksperymentalnej. W swojej rozprawie magisterskiej kładł silny nacisk na informatykę stosowaną. Po ukończeniu studiów pracował w kilku firmach jako programista Java, twórca hurtowni danych, a także analityk kontroli jakości. Jego głównymi zainteresowaniami zawodowymi są analityka biznesowa, dane wielkoskalowe, a także obliczenia w chmurze. Ivan Idris uwielbia pisać schludny, sprawdzalny kod oraz interesujące artykuły techniczne. Jest autorem książek NumPy 1.5 Beginner's Guide i NumPy Cookbook (Packt Publishing). Na stronie ivanidris.net znajdziesz więcej informacji oraz blog zawierający przykłady zastosowań biblioteki NumPy.


## Inne książki autorów
* [Python Data Analysis - Second Edition](https://www.packtpub.com/product/python-data-analysis-second-edition/9781787127487)
* [Python Data Analysis Cookbook](https://www.packtpub.com/product/python-data-analysis-cookbook/9781785282287)

### Sugestie i opinie
[Kliknij tutaj](https://docs.google.com/forms/d/e/1FAIpQLSdy7dATC6QmEL81FIUuymZ0Wy9vH1jHkvpY57OiMeKGqib_Ow/viewform), jeżeli chcesz przekazać autorom jakieś sugestie lub podzielić się opinią (po angielsku).
