import requests
import parse

NAMES = [
    'John Smyth',
    'Michael Craig',
    'Poppy-Mae Pate',
    'Vivienne Rennie',
    'Fathima Mccabe',
    'Mai Cordova',
    'Rocío García',
    'Roman Sullivan',
    'John Paul Smith',
    "Séamus O'Carroll",
    'Keagan Berg',
]

sorted_names = []
for name in NAMES:
    data = {
        'custname': name,
    }
    # Żądanie imienia i nazwiska z serwera.
    # BŁĄD Krok 2. Użycie .get zamiast .post.
    # (dawny kod) result = requests.get('http://httpbin.org/post', json=data)
    result = requests.post('http://httpbin.org/post', json=data)
    if result.status_code != 200:
        raise Exception(f'Error accessing server: {result}')
    # Pobieranie nieprzetworzonego imienia i nazwiska.
    # BŁĄD Krok 11. Pobieranie danych z surowej wartości. Zamiast
    # tego użyj odkodowanych danych w formacie JSON.
    # raw_result = result.json()['data']
    # Pobieranie nazwiska z wyniku
    # full_name = parse.search('"custname": "{name}"', raw_result)['name']
    raw_result = result.json()['json']
    full_name = raw_result['custname']
    # Podział na imię i nazwisko.
    # BŁĄD Krok 6. Podział tylko na dwa słowa, a czasem występuje też drugie imię.
    # (dawny kod) first_name, last_name = full_name.split()
    first_name, last_name = full_name.rsplit(maxsplit=1)
    ready_name = f'{last_name}, {first_name}'
    # Dodawanie do listy imienia i nazwiska w formacie nazwisko, imię.
    sorted_names.append(ready_name)

# Odpowiednie sortowanie listy i wyświetlanie wyniku.
sorted_names.sort()
print(sorted_names)
