import argparse
from google.cloud import language
from google.cloud.language import enums
from google.cloud.language import types


def main(image_file):
    content = image_file.read()
    print(f'Tekst: {content}')
    document = types.Document(content=content,
                              type=enums.Document.Type.PLAIN_TEXT)

    client = language.LanguageServiceClient()

    print('Kategorie')
    response = client.classify_text(document=document)
    if not response.categories:
        print('Nie wykryto żadnych kategorii')

    for category in response.categories:
        print(f'Kategoria: {category.name}')
        print(f'Poziom pewności: {category.confidence}')


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument(dest='input', type=argparse.FileType('r'),
                        help='Tekst wejściowy')
    args = parser.parse_args()
    main(args.input)
